package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDistributionsByKeyGroupRequest(
    marker: Option[String] = None,
    maxItems: Option[String] = None,
    keyGroupId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListDistributionsByKeyGroupRequest = {
    import ListDistributionsByKeyGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByKeyGroupRequest
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxItems.map(value => value: java.lang.String))(
        _.maxItems
      )
      .keyGroupId(keyGroupId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListDistributionsByKeyGroupRequest.ReadOnly =
    zio.aws.cloudfront.model.ListDistributionsByKeyGroupRequest
      .wrap(buildAwsValue())
}
object ListDistributionsByKeyGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByKeyGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListDistributionsByKeyGroupRequest =
      zio.aws.cloudfront.model.ListDistributionsByKeyGroupRequest(
        marker.map(value => value),
        maxItems.map(value => value),
        keyGroupId
      )
    def marker: Option[String]
    def maxItems: Option[String]
    def keyGroupId: String
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getKeyGroupId: ZIO[Any, Nothing, String] = ZIO.succeed(keyGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByKeyGroupRequest
  ) extends zio.aws.cloudfront.model.ListDistributionsByKeyGroupRequest.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val maxItems: Option[String] =
      scala.Option(impl.maxItems()).map(value => value: String)
    override val keyGroupId: String = impl.keyGroupId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByKeyGroupRequest
  ): zio.aws.cloudfront.model.ListDistributionsByKeyGroupRequest.ReadOnly =
    new Wrapper(impl)
}
