package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class OriginRequestPolicyConfig(
    comment: Option[String] = None,
    name: String,
    headersConfig: zio.aws.cloudfront.model.OriginRequestPolicyHeadersConfig,
    cookiesConfig: zio.aws.cloudfront.model.OriginRequestPolicyCookiesConfig,
    queryStringsConfig: zio.aws.cloudfront.model.OriginRequestPolicyQueryStringsConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyConfig = {
    import OriginRequestPolicyConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyConfig
      .builder()
      .optionallyWith(comment.map(value => value: java.lang.String))(_.comment)
      .name(name: java.lang.String)
      .headersConfig(headersConfig.buildAwsValue())
      .cookiesConfig(cookiesConfig.buildAwsValue())
      .queryStringsConfig(queryStringsConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.OriginRequestPolicyConfig.ReadOnly =
    zio.aws.cloudfront.model.OriginRequestPolicyConfig.wrap(buildAwsValue())
}
object OriginRequestPolicyConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.OriginRequestPolicyConfig =
      zio.aws.cloudfront.model.OriginRequestPolicyConfig(
        comment.map(value => value),
        name,
        headersConfig.asEditable,
        cookiesConfig.asEditable,
        queryStringsConfig.asEditable
      )
    def comment: Option[String]
    def name: String
    def headersConfig
        : zio.aws.cloudfront.model.OriginRequestPolicyHeadersConfig.ReadOnly
    def cookiesConfig
        : zio.aws.cloudfront.model.OriginRequestPolicyCookiesConfig.ReadOnly
    def queryStringsConfig
        : zio.aws.cloudfront.model.OriginRequestPolicyQueryStringsConfig.ReadOnly
    def getComment: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("comment", comment)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getHeadersConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.OriginRequestPolicyHeadersConfig.ReadOnly
    ] = ZIO.succeed(headersConfig)
    def getCookiesConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.OriginRequestPolicyCookiesConfig.ReadOnly
    ] = ZIO.succeed(cookiesConfig)
    def getQueryStringsConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.OriginRequestPolicyQueryStringsConfig.ReadOnly
    ] = ZIO.succeed(queryStringsConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyConfig
  ) extends zio.aws.cloudfront.model.OriginRequestPolicyConfig.ReadOnly {
    override val comment: Option[String] =
      scala.Option(impl.comment()).map(value => value: String)
    override val name: String = impl.name(): String
    override val headersConfig
        : zio.aws.cloudfront.model.OriginRequestPolicyHeadersConfig.ReadOnly =
      zio.aws.cloudfront.model.OriginRequestPolicyHeadersConfig
        .wrap(impl.headersConfig())
    override val cookiesConfig
        : zio.aws.cloudfront.model.OriginRequestPolicyCookiesConfig.ReadOnly =
      zio.aws.cloudfront.model.OriginRequestPolicyCookiesConfig
        .wrap(impl.cookiesConfig())
    override val queryStringsConfig
        : zio.aws.cloudfront.model.OriginRequestPolicyQueryStringsConfig.ReadOnly =
      zio.aws.cloudfront.model.OriginRequestPolicyQueryStringsConfig
        .wrap(impl.queryStringsConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyConfig
  ): zio.aws.cloudfront.model.OriginRequestPolicyConfig.ReadOnly = new Wrapper(
    impl
  )
}
