package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ContentTypeProfile(
    format: zio.aws.cloudfront.model.Format,
    profileId: Option[String] = None,
    contentType: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ContentTypeProfile = {
    import ContentTypeProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ContentTypeProfile
      .builder()
      .format(format.unwrap)
      .optionallyWith(profileId.map(value => value: java.lang.String))(
        _.profileId
      )
      .contentType(contentType: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ContentTypeProfile.ReadOnly =
    zio.aws.cloudfront.model.ContentTypeProfile.wrap(buildAwsValue())
}
object ContentTypeProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ContentTypeProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ContentTypeProfile =
      zio.aws.cloudfront.model
        .ContentTypeProfile(format, profileId.map(value => value), contentType)
    def format: zio.aws.cloudfront.model.Format
    def profileId: Option[String]
    def contentType: String
    def getFormat: ZIO[Any, Nothing, zio.aws.cloudfront.model.Format] =
      ZIO.succeed(format)
    def getProfileId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("profileId", profileId)
    def getContentType: ZIO[Any, Nothing, String] = ZIO.succeed(contentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ContentTypeProfile
  ) extends zio.aws.cloudfront.model.ContentTypeProfile.ReadOnly {
    override val format: zio.aws.cloudfront.model.Format =
      zio.aws.cloudfront.model.Format.wrap(impl.format())
    override val profileId: Option[String] =
      scala.Option(impl.profileId()).map(value => value: String)
    override val contentType: String = impl.contentType(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ContentTypeProfile
  ): zio.aws.cloudfront.model.ContentTypeProfile.ReadOnly = new Wrapper(impl)
}
