package zio.aws.cloudfront
import zio.aws.cloudfront.model.primitives.TagKey.Type
import java.time.Instant
import zio.aws.cloudfront.model.primitives.{TagKey, Integer}
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AliasString extends Subtype[String]
    type AliasString = zio.aws.cloudfront.model.primitives.AliasString.Type
    object CommentType extends Subtype[String]
    type CommentType = zio.aws.cloudfront.model.primitives.CommentType.Type
    object DistributionIdString extends Subtype[String]
    type DistributionIdString =
      zio.aws.cloudfront.model.primitives.DistributionIdString.Type
    object FunctionARN extends Subtype[String]
    type FunctionARN = zio.aws.cloudfront.model.primitives.FunctionARN.Type
    object FunctionBlob extends Subtype[Chunk[Byte]]
    type FunctionBlob = zio.aws.cloudfront.model.primitives.FunctionBlob.Type
    object FunctionEventObject extends Subtype[Chunk[Byte]]
    type FunctionEventObject =
      zio.aws.cloudfront.model.primitives.FunctionEventObject.Type
    object FunctionName extends Subtype[String]
    type FunctionName = zio.aws.cloudfront.model.primitives.FunctionName.Type
    object Integer extends Subtype[Int]
    type Integer = zio.aws.cloudfront.model.primitives.Integer.Type
    object LambdaFunctionARN extends Subtype[String]
    type LambdaFunctionARN =
      zio.aws.cloudfront.model.primitives.LambdaFunctionARN.Type
    object ListConflictingAliasesMaxItemsInteger extends Subtype[Int]
    type ListConflictingAliasesMaxItemsInteger =
      zio.aws.cloudfront.model.primitives.ListConflictingAliasesMaxItemsInteger.Type
    object OriginShieldRegion extends Subtype[String]
    type OriginShieldRegion =
      zio.aws.cloudfront.model.primitives.OriginShieldRegion.Type
    object ResourceARN extends Subtype[String]
    type ResourceARN = zio.aws.cloudfront.model.primitives.ResourceARN.Type
    object SensitiveStringType extends Subtype[String]
    type SensitiveStringType =
      zio.aws.cloudfront.model.primitives.SensitiveStringType.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.cloudfront.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.cloudfront.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.cloudfront.model.primitives.Timestamp.Type
  }
  type AccessControlAllowHeadersList = List[String]
  type AccessControlAllowMethodsList = List[
    zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethodsValues
  ]
  type AccessControlAllowOriginsList = List[String]
  type AccessControlExposeHeadersList = List[String]
  type AliasICPRecordals = List[zio.aws.cloudfront.model.AliasICPRecordal]
  type AliasList = List[String]
  type AwsAccountNumberList = List[String]
  type CacheBehaviorList = List[zio.aws.cloudfront.model.CacheBehavior]
  type CachePolicySummaryList =
    List[zio.aws.cloudfront.model.CachePolicySummary]
  type CloudFrontOriginAccessIdentitySummaryList =
    List[zio.aws.cloudfront.model.CloudFrontOriginAccessIdentitySummary]
  type ConflictingAliases = List[zio.aws.cloudfront.model.ConflictingAlias]
  type ContentTypeProfileList =
    List[zio.aws.cloudfront.model.ContentTypeProfile]
  type CookieNameList = List[String]
  type CustomErrorResponseList =
    List[zio.aws.cloudfront.model.CustomErrorResponse]
  type DistributionIdListSummary = List[String]
  type DistributionSummaryList =
    List[zio.aws.cloudfront.model.DistributionSummary]
  type EncryptionEntityList = List[zio.aws.cloudfront.model.EncryptionEntity]
  type EndPointList = List[zio.aws.cloudfront.model.EndPoint]
  type FieldLevelEncryptionProfileSummaryList =
    List[zio.aws.cloudfront.model.FieldLevelEncryptionProfileSummary]
  type FieldLevelEncryptionSummaryList =
    List[zio.aws.cloudfront.model.FieldLevelEncryptionSummary]
  type FieldList = List[String]
  type FieldPatternList = List[String]
  type FunctionAssociationList =
    List[zio.aws.cloudfront.model.FunctionAssociation]
  type FunctionExecutionLogList = List[String]
  type FunctionSummaryList = List[zio.aws.cloudfront.model.FunctionSummary]
  type HeaderList = List[String]
  type InvalidationSummaryList =
    List[zio.aws.cloudfront.model.InvalidationSummary]
  type KGKeyPairIdsList = List[zio.aws.cloudfront.model.KGKeyPairIds]
  type KeyGroupSummaryList = List[zio.aws.cloudfront.model.KeyGroupSummary]
  type KeyPairIdList = List[String]
  type LambdaFunctionAssociationList =
    List[zio.aws.cloudfront.model.LambdaFunctionAssociation]
  type LocationList = List[String]
  type MethodsList = List[zio.aws.cloudfront.model.Method]
  type OriginCustomHeadersList =
    List[zio.aws.cloudfront.model.OriginCustomHeader]
  type OriginGroupList = List[zio.aws.cloudfront.model.OriginGroup]
  type OriginGroupMemberList = List[zio.aws.cloudfront.model.OriginGroupMember]
  type OriginList = List[zio.aws.cloudfront.model.Origin]
  type OriginRequestPolicySummaryList =
    List[zio.aws.cloudfront.model.OriginRequestPolicySummary]
  type PathList = List[String]
  type PublicKeyIdList = List[String]
  type PublicKeySummaryList = List[zio.aws.cloudfront.model.PublicKeySummary]
  type QueryArgProfileList = List[zio.aws.cloudfront.model.QueryArgProfile]
  type QueryStringCacheKeysList = List[String]
  type QueryStringNamesList = List[String]
  type RealtimeLogConfigList = List[zio.aws.cloudfront.model.RealtimeLogConfig]
  type ResponseHeadersPolicyCustomHeaderList =
    List[zio.aws.cloudfront.model.ResponseHeadersPolicyCustomHeader]
  type ResponseHeadersPolicySummaryList =
    List[zio.aws.cloudfront.model.ResponseHeadersPolicySummary]
  type SignerList = List[zio.aws.cloudfront.model.Signer]
  type SslProtocolsList = List[zio.aws.cloudfront.model.SslProtocol]
  type StatusCodeList = List[Integer]
  type StreamingDistributionSummaryList =
    List[zio.aws.cloudfront.model.StreamingDistributionSummary]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.cloudfront.model.Tag]
  type TrustedKeyGroupIdList = List[String]
}
