package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetFieldLevelEncryptionConfigResponse(
    fieldLevelEncryptionConfig: Option[
      zio.aws.cloudfront.model.FieldLevelEncryptionConfig
    ] = None,
    eTag: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigResponse = {
    import GetFieldLevelEncryptionConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigResponse
      .builder()
      .optionallyWith(
        fieldLevelEncryptionConfig.map(value => value.buildAwsValue())
      )(_.fieldLevelEncryptionConfig)
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetFieldLevelEncryptionConfigResponse.ReadOnly =
    zio.aws.cloudfront.model.GetFieldLevelEncryptionConfigResponse
      .wrap(buildAwsValue())
}
object GetFieldLevelEncryptionConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.GetFieldLevelEncryptionConfigResponse =
      zio.aws.cloudfront.model.GetFieldLevelEncryptionConfigResponse(
        fieldLevelEncryptionConfig.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def fieldLevelEncryptionConfig
        : Option[zio.aws.cloudfront.model.FieldLevelEncryptionConfig.ReadOnly]
    def eTag: Option[String]
    def getFieldLevelEncryptionConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.FieldLevelEncryptionConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "fieldLevelEncryptionConfig",
      fieldLevelEncryptionConfig
    )
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigResponse
  ) extends zio.aws.cloudfront.model.GetFieldLevelEncryptionConfigResponse.ReadOnly {
    override val fieldLevelEncryptionConfig
        : Option[zio.aws.cloudfront.model.FieldLevelEncryptionConfig.ReadOnly] =
      scala
        .Option(impl.fieldLevelEncryptionConfig())
        .map(value =>
          zio.aws.cloudfront.model.FieldLevelEncryptionConfig.wrap(value)
        )
    override val eTag: Option[String] =
      scala.Option(impl.eTag()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigResponse
  ): zio.aws.cloudfront.model.GetFieldLevelEncryptionConfigResponse.ReadOnly =
    new Wrapper(impl)
}
