package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateDistributionResponse(
    distribution: Option[zio.aws.cloudfront.model.Distribution] = None,
    eTag: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateDistributionResponse = {
    import UpdateDistributionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateDistributionResponse
      .builder()
      .optionallyWith(distribution.map(value => value.buildAwsValue()))(
        _.distribution
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.UpdateDistributionResponse.ReadOnly =
    zio.aws.cloudfront.model.UpdateDistributionResponse.wrap(buildAwsValue())
}
object UpdateDistributionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateDistributionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdateDistributionResponse =
      zio.aws.cloudfront.model.UpdateDistributionResponse(
        distribution.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def distribution: Option[zio.aws.cloudfront.model.Distribution.ReadOnly]
    def eTag: Option[String]
    def getDistribution
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.Distribution.ReadOnly] =
      AwsError.unwrapOptionField("distribution", distribution)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateDistributionResponse
  ) extends zio.aws.cloudfront.model.UpdateDistributionResponse.ReadOnly {
    override val distribution
        : Option[zio.aws.cloudfront.model.Distribution.ReadOnly] = scala
      .Option(impl.distribution())
      .map(value => zio.aws.cloudfront.model.Distribution.wrap(value))
    override val eTag: Option[String] =
      scala.Option(impl.eTag()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateDistributionResponse
  ): zio.aws.cloudfront.model.UpdateDistributionResponse.ReadOnly = new Wrapper(
    impl
  )
}
