package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class QueryArgProfileConfig(
    forwardWhenQueryArgProfileIsUnknown: Boolean,
    queryArgProfiles: Option[zio.aws.cloudfront.model.QueryArgProfiles] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.QueryArgProfileConfig = {
    import QueryArgProfileConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.QueryArgProfileConfig
      .builder()
      .forwardWhenQueryArgProfileIsUnknown(
        forwardWhenQueryArgProfileIsUnknown: java.lang.Boolean
      )
      .optionallyWith(queryArgProfiles.map(value => value.buildAwsValue()))(
        _.queryArgProfiles
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.QueryArgProfileConfig.ReadOnly =
    zio.aws.cloudfront.model.QueryArgProfileConfig.wrap(buildAwsValue())
}
object QueryArgProfileConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.QueryArgProfileConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.QueryArgProfileConfig =
      zio.aws.cloudfront.model.QueryArgProfileConfig(
        forwardWhenQueryArgProfileIsUnknown,
        queryArgProfiles.map(value => value.asEditable)
      )
    def forwardWhenQueryArgProfileIsUnknown: Boolean
    def queryArgProfiles
        : Option[zio.aws.cloudfront.model.QueryArgProfiles.ReadOnly]
    def getForwardWhenQueryArgProfileIsUnknown: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(forwardWhenQueryArgProfileIsUnknown)
    def getQueryArgProfiles: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.QueryArgProfiles.ReadOnly
    ] = AwsError.unwrapOptionField("queryArgProfiles", queryArgProfiles)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.QueryArgProfileConfig
  ) extends zio.aws.cloudfront.model.QueryArgProfileConfig.ReadOnly {
    override val forwardWhenQueryArgProfileIsUnknown: Boolean =
      impl.forwardWhenQueryArgProfileIsUnknown(): Boolean
    override val queryArgProfiles
        : Option[zio.aws.cloudfront.model.QueryArgProfiles.ReadOnly] = scala
      .Option(impl.queryArgProfiles())
      .map(value => zio.aws.cloudfront.model.QueryArgProfiles.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.QueryArgProfileConfig
  ): zio.aws.cloudfront.model.QueryArgProfileConfig.ReadOnly = new Wrapper(impl)
}
