package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class KeyGroupSummary(keyGroup: zio.aws.cloudfront.model.KeyGroup) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.KeyGroupSummary = {
    import KeyGroupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.KeyGroupSummary
      .builder()
      .keyGroup(keyGroup.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.KeyGroupSummary.ReadOnly =
    zio.aws.cloudfront.model.KeyGroupSummary.wrap(buildAwsValue())
}
object KeyGroupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.KeyGroupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.KeyGroupSummary =
      zio.aws.cloudfront.model.KeyGroupSummary(keyGroup.asEditable)
    def keyGroup: zio.aws.cloudfront.model.KeyGroup.ReadOnly
    def getKeyGroup
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.KeyGroup.ReadOnly] =
      ZIO.succeed(keyGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.KeyGroupSummary
  ) extends zio.aws.cloudfront.model.KeyGroupSummary.ReadOnly {
    override val keyGroup: zio.aws.cloudfront.model.KeyGroup.ReadOnly =
      zio.aws.cloudfront.model.KeyGroup.wrap(impl.keyGroup())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.KeyGroupSummary
  ): zio.aws.cloudfront.model.KeyGroupSummary.ReadOnly = new Wrapper(impl)
}
