package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateResponseHeadersPolicyResponse(
    responseHeadersPolicy: Option[
      zio.aws.cloudfront.model.ResponseHeadersPolicy
    ] = None,
    eTag: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateResponseHeadersPolicyResponse = {
    import UpdateResponseHeadersPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateResponseHeadersPolicyResponse
      .builder()
      .optionallyWith(
        responseHeadersPolicy.map(value => value.buildAwsValue())
      )(_.responseHeadersPolicy)
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.UpdateResponseHeadersPolicyResponse.ReadOnly =
    zio.aws.cloudfront.model.UpdateResponseHeadersPolicyResponse
      .wrap(buildAwsValue())
}
object UpdateResponseHeadersPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateResponseHeadersPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.UpdateResponseHeadersPolicyResponse =
      zio.aws.cloudfront.model.UpdateResponseHeadersPolicyResponse(
        responseHeadersPolicy.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def responseHeadersPolicy
        : Option[zio.aws.cloudfront.model.ResponseHeadersPolicy.ReadOnly]
    def eTag: Option[String]
    def getResponseHeadersPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ResponseHeadersPolicy.ReadOnly
    ] =
      AwsError.unwrapOptionField("responseHeadersPolicy", responseHeadersPolicy)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateResponseHeadersPolicyResponse
  ) extends zio.aws.cloudfront.model.UpdateResponseHeadersPolicyResponse.ReadOnly {
    override val responseHeadersPolicy
        : Option[zio.aws.cloudfront.model.ResponseHeadersPolicy.ReadOnly] =
      scala
        .Option(impl.responseHeadersPolicy())
        .map(value =>
          zio.aws.cloudfront.model.ResponseHeadersPolicy.wrap(value)
        )
    override val eTag: Option[String] =
      scala.Option(impl.eTag()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateResponseHeadersPolicyResponse
  ): zio.aws.cloudfront.model.UpdateResponseHeadersPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
