package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class ResponseHeadersPolicyAccessControlExposeHeaders(
    quantity: Integer,
    items: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyAccessControlExposeHeaders = {
    import ResponseHeadersPolicyAccessControlExposeHeaders.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyAccessControlExposeHeaders
      .builder()
      .quantity(Integer.unwrap(quantity): java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlExposeHeaders.ReadOnly =
    zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlExposeHeaders
      .wrap(buildAwsValue())
}
object ResponseHeadersPolicyAccessControlExposeHeaders {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyAccessControlExposeHeaders
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlExposeHeaders =
      zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlExposeHeaders(
        quantity,
        items.map(value => value)
      )
    def quantity: Integer
    def items: Option[List[String]]
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyAccessControlExposeHeaders
  ) extends zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlExposeHeaders.ReadOnly {
    override val quantity: Integer =
      zio.aws.cloudfront.model.primitives.Integer(impl.quantity())
    override val items: Option[List[String]] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyAccessControlExposeHeaders
  ): zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlExposeHeaders.ReadOnly =
    new Wrapper(impl)
}
