package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListInvalidationsResponse(
    invalidationList: Option[zio.aws.cloudfront.model.InvalidationList] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListInvalidationsResponse = {
    import ListInvalidationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListInvalidationsResponse
      .builder()
      .optionallyWith(invalidationList.map(value => value.buildAwsValue()))(
        _.invalidationList
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ListInvalidationsResponse.ReadOnly =
    zio.aws.cloudfront.model.ListInvalidationsResponse.wrap(buildAwsValue())
}
object ListInvalidationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListInvalidationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListInvalidationsResponse =
      zio.aws.cloudfront.model.ListInvalidationsResponse(
        invalidationList.map(value => value.asEditable)
      )
    def invalidationList
        : Option[zio.aws.cloudfront.model.InvalidationList.ReadOnly]
    def getInvalidationList: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.InvalidationList.ReadOnly
    ] = AwsError.unwrapOptionField("invalidationList", invalidationList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListInvalidationsResponse
  ) extends zio.aws.cloudfront.model.ListInvalidationsResponse.ReadOnly {
    override val invalidationList
        : Option[zio.aws.cloudfront.model.InvalidationList.ReadOnly] = scala
      .Option(impl.invalidationList())
      .map(value => zio.aws.cloudfront.model.InvalidationList.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListInvalidationsResponse
  ): zio.aws.cloudfront.model.ListInvalidationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
