package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class LambdaFunctionAssociations(
    quantity: Integer,
    items: Option[
      Iterable[zio.aws.cloudfront.model.LambdaFunctionAssociation]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.LambdaFunctionAssociations = {
    import LambdaFunctionAssociations.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.LambdaFunctionAssociations
      .builder()
      .quantity(Integer.unwrap(quantity): java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.LambdaFunctionAssociations.ReadOnly =
    zio.aws.cloudfront.model.LambdaFunctionAssociations.wrap(buildAwsValue())
}
object LambdaFunctionAssociations {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.LambdaFunctionAssociations
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.LambdaFunctionAssociations =
      zio.aws.cloudfront.model.LambdaFunctionAssociations(
        quantity,
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def quantity: Integer
    def items: Option[
      List[zio.aws.cloudfront.model.LambdaFunctionAssociation.ReadOnly]
    ]
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.LambdaFunctionAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.LambdaFunctionAssociations
  ) extends zio.aws.cloudfront.model.LambdaFunctionAssociations.ReadOnly {
    override val quantity: Integer =
      zio.aws.cloudfront.model.primitives.Integer(impl.quantity())
    override val items: Option[
      List[zio.aws.cloudfront.model.LambdaFunctionAssociation.ReadOnly]
    ] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudfront.model.LambdaFunctionAssociation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.LambdaFunctionAssociations
  ): zio.aws.cloudfront.model.LambdaFunctionAssociations.ReadOnly = new Wrapper(
    impl
  )
}
