package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.CommentType
import scala.jdk.CollectionConverters._
final case class DistributionConfig(
    callerReference: String,
    aliases: Option[zio.aws.cloudfront.model.Aliases] = None,
    defaultRootObject: Option[String] = None,
    origins: zio.aws.cloudfront.model.Origins,
    originGroups: Option[zio.aws.cloudfront.model.OriginGroups] = None,
    defaultCacheBehavior: zio.aws.cloudfront.model.DefaultCacheBehavior,
    cacheBehaviors: Option[zio.aws.cloudfront.model.CacheBehaviors] = None,
    customErrorResponses: Option[
      zio.aws.cloudfront.model.CustomErrorResponses
    ] = None,
    comment: CommentType,
    logging: Option[zio.aws.cloudfront.model.LoggingConfig] = None,
    priceClass: Option[zio.aws.cloudfront.model.PriceClass] = None,
    enabled: Boolean,
    viewerCertificate: Option[zio.aws.cloudfront.model.ViewerCertificate] =
      None,
    restrictions: Option[zio.aws.cloudfront.model.Restrictions] = None,
    webACLId: Option[String] = None,
    httpVersion: Option[zio.aws.cloudfront.model.HttpVersion] = None,
    isIPV6Enabled: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DistributionConfig = {
    import DistributionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DistributionConfig
      .builder()
      .callerReference(callerReference: java.lang.String)
      .optionallyWith(aliases.map(value => value.buildAwsValue()))(_.aliases)
      .optionallyWith(defaultRootObject.map(value => value: java.lang.String))(
        _.defaultRootObject
      )
      .origins(origins.buildAwsValue())
      .optionallyWith(originGroups.map(value => value.buildAwsValue()))(
        _.originGroups
      )
      .defaultCacheBehavior(defaultCacheBehavior.buildAwsValue())
      .optionallyWith(cacheBehaviors.map(value => value.buildAwsValue()))(
        _.cacheBehaviors
      )
      .optionallyWith(customErrorResponses.map(value => value.buildAwsValue()))(
        _.customErrorResponses
      )
      .comment(CommentType.unwrap(comment): java.lang.String)
      .optionallyWith(logging.map(value => value.buildAwsValue()))(_.logging)
      .optionallyWith(priceClass.map(value => value.unwrap))(_.priceClass)
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(viewerCertificate.map(value => value.buildAwsValue()))(
        _.viewerCertificate
      )
      .optionallyWith(restrictions.map(value => value.buildAwsValue()))(
        _.restrictions
      )
      .optionallyWith(webACLId.map(value => value: java.lang.String))(
        _.webACLId
      )
      .optionallyWith(httpVersion.map(value => value.unwrap))(_.httpVersion)
      .optionallyWith(isIPV6Enabled.map(value => value: java.lang.Boolean))(
        _.isIPV6Enabled
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.DistributionConfig.ReadOnly =
    zio.aws.cloudfront.model.DistributionConfig.wrap(buildAwsValue())
}
object DistributionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DistributionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DistributionConfig =
      zio.aws.cloudfront.model.DistributionConfig(
        callerReference,
        aliases.map(value => value.asEditable),
        defaultRootObject.map(value => value),
        origins.asEditable,
        originGroups.map(value => value.asEditable),
        defaultCacheBehavior.asEditable,
        cacheBehaviors.map(value => value.asEditable),
        customErrorResponses.map(value => value.asEditable),
        comment,
        logging.map(value => value.asEditable),
        priceClass.map(value => value),
        enabled,
        viewerCertificate.map(value => value.asEditable),
        restrictions.map(value => value.asEditable),
        webACLId.map(value => value),
        httpVersion.map(value => value),
        isIPV6Enabled.map(value => value)
      )
    def callerReference: String
    def aliases: Option[zio.aws.cloudfront.model.Aliases.ReadOnly]
    def defaultRootObject: Option[String]
    def origins: zio.aws.cloudfront.model.Origins.ReadOnly
    def originGroups: Option[zio.aws.cloudfront.model.OriginGroups.ReadOnly]
    def defaultCacheBehavior
        : zio.aws.cloudfront.model.DefaultCacheBehavior.ReadOnly
    def cacheBehaviors: Option[zio.aws.cloudfront.model.CacheBehaviors.ReadOnly]
    def customErrorResponses
        : Option[zio.aws.cloudfront.model.CustomErrorResponses.ReadOnly]
    def comment: CommentType
    def logging: Option[zio.aws.cloudfront.model.LoggingConfig.ReadOnly]
    def priceClass: Option[zio.aws.cloudfront.model.PriceClass]
    def enabled: Boolean
    def viewerCertificate
        : Option[zio.aws.cloudfront.model.ViewerCertificate.ReadOnly]
    def restrictions: Option[zio.aws.cloudfront.model.Restrictions.ReadOnly]
    def webACLId: Option[String]
    def httpVersion: Option[zio.aws.cloudfront.model.HttpVersion]
    def isIPV6Enabled: Option[Boolean]
    def getCallerReference: ZIO[Any, Nothing, String] =
      ZIO.succeed(callerReference)
    def getAliases
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.Aliases.ReadOnly] =
      AwsError.unwrapOptionField("aliases", aliases)
    def getDefaultRootObject: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultRootObject", defaultRootObject)
    def getOrigins
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.Origins.ReadOnly] =
      ZIO.succeed(origins)
    def getOriginGroups
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.OriginGroups.ReadOnly] =
      AwsError.unwrapOptionField("originGroups", originGroups)
    def getDefaultCacheBehavior: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.DefaultCacheBehavior.ReadOnly
    ] = ZIO.succeed(defaultCacheBehavior)
    def getCacheBehaviors
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.CacheBehaviors.ReadOnly] =
      AwsError.unwrapOptionField("cacheBehaviors", cacheBehaviors)
    def getCustomErrorResponses: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.CustomErrorResponses.ReadOnly
    ] = AwsError.unwrapOptionField("customErrorResponses", customErrorResponses)
    def getComment: ZIO[Any, Nothing, CommentType] = ZIO.succeed(comment)
    def getLogging
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.LoggingConfig.ReadOnly] =
      AwsError.unwrapOptionField("logging", logging)
    def getPriceClass: ZIO[Any, AwsError, zio.aws.cloudfront.model.PriceClass] =
      AwsError.unwrapOptionField("priceClass", priceClass)
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getViewerCertificate: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ViewerCertificate.ReadOnly
    ] = AwsError.unwrapOptionField("viewerCertificate", viewerCertificate)
    def getRestrictions
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.Restrictions.ReadOnly] =
      AwsError.unwrapOptionField("restrictions", restrictions)
    def getWebACLId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("webACLId", webACLId)
    def getHttpVersion
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.HttpVersion] =
      AwsError.unwrapOptionField("httpVersion", httpVersion)
    def getIsIPV6Enabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isIPV6Enabled", isIPV6Enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DistributionConfig
  ) extends zio.aws.cloudfront.model.DistributionConfig.ReadOnly {
    override val callerReference: String = impl.callerReference(): String
    override val aliases: Option[zio.aws.cloudfront.model.Aliases.ReadOnly] =
      scala
        .Option(impl.aliases())
        .map(value => zio.aws.cloudfront.model.Aliases.wrap(value))
    override val defaultRootObject: Option[String] =
      scala.Option(impl.defaultRootObject()).map(value => value: String)
    override val origins: zio.aws.cloudfront.model.Origins.ReadOnly =
      zio.aws.cloudfront.model.Origins.wrap(impl.origins())
    override val originGroups
        : Option[zio.aws.cloudfront.model.OriginGroups.ReadOnly] = scala
      .Option(impl.originGroups())
      .map(value => zio.aws.cloudfront.model.OriginGroups.wrap(value))
    override val defaultCacheBehavior
        : zio.aws.cloudfront.model.DefaultCacheBehavior.ReadOnly =
      zio.aws.cloudfront.model.DefaultCacheBehavior
        .wrap(impl.defaultCacheBehavior())
    override val cacheBehaviors
        : Option[zio.aws.cloudfront.model.CacheBehaviors.ReadOnly] = scala
      .Option(impl.cacheBehaviors())
      .map(value => zio.aws.cloudfront.model.CacheBehaviors.wrap(value))
    override val customErrorResponses
        : Option[zio.aws.cloudfront.model.CustomErrorResponses.ReadOnly] = scala
      .Option(impl.customErrorResponses())
      .map(value => zio.aws.cloudfront.model.CustomErrorResponses.wrap(value))
    override val comment: CommentType =
      zio.aws.cloudfront.model.primitives.CommentType(impl.comment())
    override val logging
        : Option[zio.aws.cloudfront.model.LoggingConfig.ReadOnly] = scala
      .Option(impl.logging())
      .map(value => zio.aws.cloudfront.model.LoggingConfig.wrap(value))
    override val priceClass: Option[zio.aws.cloudfront.model.PriceClass] = scala
      .Option(impl.priceClass())
      .map(value => zio.aws.cloudfront.model.PriceClass.wrap(value))
    override val enabled: Boolean = impl.enabled(): Boolean
    override val viewerCertificate
        : Option[zio.aws.cloudfront.model.ViewerCertificate.ReadOnly] = scala
      .Option(impl.viewerCertificate())
      .map(value => zio.aws.cloudfront.model.ViewerCertificate.wrap(value))
    override val restrictions
        : Option[zio.aws.cloudfront.model.Restrictions.ReadOnly] = scala
      .Option(impl.restrictions())
      .map(value => zio.aws.cloudfront.model.Restrictions.wrap(value))
    override val webACLId: Option[String] =
      scala.Option(impl.webACLId()).map(value => value: String)
    override val httpVersion: Option[zio.aws.cloudfront.model.HttpVersion] =
      scala
        .Option(impl.httpVersion())
        .map(value => zio.aws.cloudfront.model.HttpVersion.wrap(value))
    override val isIPV6Enabled: Option[Boolean] =
      scala.Option(impl.isIPV6Enabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DistributionConfig
  ): zio.aws.cloudfront.model.DistributionConfig.ReadOnly = new Wrapper(impl)
}
