package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateMonitoringSubscriptionResponse(
    monitoringSubscription: Option[
      zio.aws.cloudfront.model.MonitoringSubscription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateMonitoringSubscriptionResponse = {
    import CreateMonitoringSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateMonitoringSubscriptionResponse
      .builder()
      .optionallyWith(
        monitoringSubscription.map(value => value.buildAwsValue())
      )(_.monitoringSubscription)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateMonitoringSubscriptionResponse.ReadOnly =
    zio.aws.cloudfront.model.CreateMonitoringSubscriptionResponse
      .wrap(buildAwsValue())
}
object CreateMonitoringSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateMonitoringSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.CreateMonitoringSubscriptionResponse =
      zio.aws.cloudfront.model.CreateMonitoringSubscriptionResponse(
        monitoringSubscription.map(value => value.asEditable)
      )
    def monitoringSubscription
        : Option[zio.aws.cloudfront.model.MonitoringSubscription.ReadOnly]
    def getMonitoringSubscription: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.MonitoringSubscription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "monitoringSubscription",
      monitoringSubscription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateMonitoringSubscriptionResponse
  ) extends zio.aws.cloudfront.model.CreateMonitoringSubscriptionResponse.ReadOnly {
    override val monitoringSubscription
        : Option[zio.aws.cloudfront.model.MonitoringSubscription.ReadOnly] =
      scala
        .Option(impl.monitoringSubscription())
        .map(value =>
          zio.aws.cloudfront.model.MonitoringSubscription.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateMonitoringSubscriptionResponse
  ): zio.aws.cloudfront.model.CreateMonitoringSubscriptionResponse.ReadOnly =
    new Wrapper(impl)
}
