package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class ResponseHeadersPolicyAccessControlAllowHeaders(
    quantity: Integer,
    items: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowHeaders = {
    import ResponseHeadersPolicyAccessControlAllowHeaders.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowHeaders
      .builder()
      .quantity(Integer.unwrap(quantity): java.lang.Integer)
      .items(items.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowHeaders.ReadOnly =
    zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowHeaders
      .wrap(buildAwsValue())
}
object ResponseHeadersPolicyAccessControlAllowHeaders {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowHeaders
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowHeaders =
      zio.aws.cloudfront.model
        .ResponseHeadersPolicyAccessControlAllowHeaders(quantity, items)
    def quantity: Integer
    def items: List[String]
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, Nothing, List[String]] = ZIO.succeed(items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowHeaders
  ) extends zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowHeaders.ReadOnly {
    override val quantity: Integer =
      zio.aws.cloudfront.model.primitives.Integer(impl.quantity())
    override val items: List[String] = impl
      .items()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowHeaders
  ): zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowHeaders.ReadOnly =
    new Wrapper(impl)
}
