package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateKeyGroupResponse(
    keyGroup: Option[zio.aws.cloudfront.model.KeyGroup] = None,
    location: Option[String] = None,
    eTag: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateKeyGroupResponse = {
    import CreateKeyGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateKeyGroupResponse
      .builder()
      .optionallyWith(keyGroup.map(value => value.buildAwsValue()))(_.keyGroup)
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CreateKeyGroupResponse.ReadOnly =
    zio.aws.cloudfront.model.CreateKeyGroupResponse.wrap(buildAwsValue())
}
object CreateKeyGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateKeyGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateKeyGroupResponse =
      zio.aws.cloudfront.model.CreateKeyGroupResponse(
        keyGroup.map(value => value.asEditable),
        location.map(value => value),
        eTag.map(value => value)
      )
    def keyGroup: Option[zio.aws.cloudfront.model.KeyGroup.ReadOnly]
    def location: Option[String]
    def eTag: Option[String]
    def getKeyGroup
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.KeyGroup.ReadOnly] =
      AwsError.unwrapOptionField("keyGroup", keyGroup)
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateKeyGroupResponse
  ) extends zio.aws.cloudfront.model.CreateKeyGroupResponse.ReadOnly {
    override val keyGroup: Option[zio.aws.cloudfront.model.KeyGroup.ReadOnly] =
      scala
        .Option(impl.keyGroup())
        .map(value => zio.aws.cloudfront.model.KeyGroup.wrap(value))
    override val location: Option[String] =
      scala.Option(impl.location()).map(value => value: String)
    override val eTag: Option[String] =
      scala.Option(impl.eTag()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateKeyGroupResponse
  ): zio.aws.cloudfront.model.CreateKeyGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
