package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListConflictingAliasesResponse(
    conflictingAliasesList: Option[
      zio.aws.cloudfront.model.ConflictingAliasesList
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListConflictingAliasesResponse = {
    import ListConflictingAliasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListConflictingAliasesResponse
      .builder()
      .optionallyWith(
        conflictingAliasesList.map(value => value.buildAwsValue())
      )(_.conflictingAliasesList)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListConflictingAliasesResponse.ReadOnly =
    zio.aws.cloudfront.model.ListConflictingAliasesResponse
      .wrap(buildAwsValue())
}
object ListConflictingAliasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListConflictingAliasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListConflictingAliasesResponse =
      zio.aws.cloudfront.model.ListConflictingAliasesResponse(
        conflictingAliasesList.map(value => value.asEditable)
      )
    def conflictingAliasesList
        : Option[zio.aws.cloudfront.model.ConflictingAliasesList.ReadOnly]
    def getConflictingAliasesList: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ConflictingAliasesList.ReadOnly
    ] = AwsError.unwrapOptionField(
      "conflictingAliasesList",
      conflictingAliasesList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListConflictingAliasesResponse
  ) extends zio.aws.cloudfront.model.ListConflictingAliasesResponse.ReadOnly {
    override val conflictingAliasesList
        : Option[zio.aws.cloudfront.model.ConflictingAliasesList.ReadOnly] =
      scala
        .Option(impl.conflictingAliasesList())
        .map(value =>
          zio.aws.cloudfront.model.ConflictingAliasesList.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListConflictingAliasesResponse
  ): zio.aws.cloudfront.model.ListConflictingAliasesResponse.ReadOnly =
    new Wrapper(impl)
}
