package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateOriginRequestPolicyResponse(
    originRequestPolicy: Option[zio.aws.cloudfront.model.OriginRequestPolicy] =
      None,
    eTag: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyResponse = {
    import UpdateOriginRequestPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyResponse
      .builder()
      .optionallyWith(originRequestPolicy.map(value => value.buildAwsValue()))(
        _.originRequestPolicy
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.UpdateOriginRequestPolicyResponse.ReadOnly =
    zio.aws.cloudfront.model.UpdateOriginRequestPolicyResponse
      .wrap(buildAwsValue())
}
object UpdateOriginRequestPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdateOriginRequestPolicyResponse =
      zio.aws.cloudfront.model.UpdateOriginRequestPolicyResponse(
        originRequestPolicy.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def originRequestPolicy
        : Option[zio.aws.cloudfront.model.OriginRequestPolicy.ReadOnly]
    def eTag: Option[String]
    def getOriginRequestPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.OriginRequestPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("originRequestPolicy", originRequestPolicy)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyResponse
  ) extends zio.aws.cloudfront.model.UpdateOriginRequestPolicyResponse.ReadOnly {
    override val originRequestPolicy
        : Option[zio.aws.cloudfront.model.OriginRequestPolicy.ReadOnly] = scala
      .Option(impl.originRequestPolicy())
      .map(value => zio.aws.cloudfront.model.OriginRequestPolicy.wrap(value))
    override val eTag: Option[String] =
      scala.Option(impl.eTag()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyResponse
  ): zio.aws.cloudfront.model.UpdateOriginRequestPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
