package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.SensitiveStringType
import scala.jdk.CollectionConverters._
final case class TestResult(
    functionSummary: Option[zio.aws.cloudfront.model.FunctionSummary] = None,
    computeUtilization: Option[String] = None,
    functionExecutionLogs: Option[Iterable[String]] = None,
    functionErrorMessage: Option[SensitiveStringType] = None,
    functionOutput: Option[SensitiveStringType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.TestResult = {
    import TestResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.TestResult
      .builder()
      .optionallyWith(functionSummary.map(value => value.buildAwsValue()))(
        _.functionSummary
      )
      .optionallyWith(computeUtilization.map(value => value: java.lang.String))(
        _.computeUtilization
      )
      .optionallyWith(
        functionExecutionLogs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.functionExecutionLogs)
      .optionallyWith(
        functionErrorMessage.map(value =>
          SensitiveStringType.unwrap(value): java.lang.String
        )
      )(_.functionErrorMessage)
      .optionallyWith(
        functionOutput.map(value =>
          SensitiveStringType.unwrap(value): java.lang.String
        )
      )(_.functionOutput)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.TestResult.ReadOnly =
    zio.aws.cloudfront.model.TestResult.wrap(buildAwsValue())
}
object TestResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.TestResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.TestResult =
      zio.aws.cloudfront.model.TestResult(
        functionSummary.map(value => value.asEditable),
        computeUtilization.map(value => value),
        functionExecutionLogs.map(value => value),
        functionErrorMessage.map(value => value),
        functionOutput.map(value => value)
      )
    def functionSummary
        : Option[zio.aws.cloudfront.model.FunctionSummary.ReadOnly]
    def computeUtilization: Option[String]
    def functionExecutionLogs: Option[List[String]]
    def functionErrorMessage: Option[SensitiveStringType]
    def functionOutput: Option[SensitiveStringType]
    def getFunctionSummary: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.FunctionSummary.ReadOnly
    ] = AwsError.unwrapOptionField("functionSummary", functionSummary)
    def getComputeUtilization: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("computeUtilization", computeUtilization)
    def getFunctionExecutionLogs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("functionExecutionLogs", functionExecutionLogs)
    def getFunctionErrorMessage: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("functionErrorMessage", functionErrorMessage)
    def getFunctionOutput: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("functionOutput", functionOutput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.TestResult
  ) extends zio.aws.cloudfront.model.TestResult.ReadOnly {
    override val functionSummary
        : Option[zio.aws.cloudfront.model.FunctionSummary.ReadOnly] = scala
      .Option(impl.functionSummary())
      .map(value => zio.aws.cloudfront.model.FunctionSummary.wrap(value))
    override val computeUtilization: Option[String] =
      scala.Option(impl.computeUtilization()).map(value => value: String)
    override val functionExecutionLogs: Option[List[String]] = scala
      .Option(impl.functionExecutionLogs())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val functionErrorMessage: Option[SensitiveStringType] = scala
      .Option(impl.functionErrorMessage())
      .map(value =>
        zio.aws.cloudfront.model.primitives.SensitiveStringType(value)
      )
    override val functionOutput: Option[SensitiveStringType] = scala
      .Option(impl.functionOutput())
      .map(value =>
        zio.aws.cloudfront.model.primitives.SensitiveStringType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.TestResult
  ): zio.aws.cloudfront.model.TestResult.ReadOnly = new Wrapper(impl)
}
