package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListKeyGroupsResponse(
    keyGroupList: Option[zio.aws.cloudfront.model.KeyGroupList] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsResponse = {
    import ListKeyGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsResponse
      .builder()
      .optionallyWith(keyGroupList.map(value => value.buildAwsValue()))(
        _.keyGroupList
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ListKeyGroupsResponse.ReadOnly =
    zio.aws.cloudfront.model.ListKeyGroupsResponse.wrap(buildAwsValue())
}
object ListKeyGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListKeyGroupsResponse =
      zio.aws.cloudfront.model
        .ListKeyGroupsResponse(keyGroupList.map(value => value.asEditable))
    def keyGroupList: Option[zio.aws.cloudfront.model.KeyGroupList.ReadOnly]
    def getKeyGroupList
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.KeyGroupList.ReadOnly] =
      AwsError.unwrapOptionField("keyGroupList", keyGroupList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsResponse
  ) extends zio.aws.cloudfront.model.ListKeyGroupsResponse.ReadOnly {
    override val keyGroupList
        : Option[zio.aws.cloudfront.model.KeyGroupList.ReadOnly] = scala
      .Option(impl.keyGroupList())
      .map(value => zio.aws.cloudfront.model.KeyGroupList.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsResponse
  ): zio.aws.cloudfront.model.ListKeyGroupsResponse.ReadOnly = new Wrapper(impl)
}
