package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListFunctionsResponse(
    functionList: Option[zio.aws.cloudfront.model.FunctionList] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListFunctionsResponse = {
    import ListFunctionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListFunctionsResponse
      .builder()
      .optionallyWith(functionList.map(value => value.buildAwsValue()))(
        _.functionList
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ListFunctionsResponse.ReadOnly =
    zio.aws.cloudfront.model.ListFunctionsResponse.wrap(buildAwsValue())
}
object ListFunctionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListFunctionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListFunctionsResponse =
      zio.aws.cloudfront.model
        .ListFunctionsResponse(functionList.map(value => value.asEditable))
    def functionList: Option[zio.aws.cloudfront.model.FunctionList.ReadOnly]
    def getFunctionList
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.FunctionList.ReadOnly] =
      AwsError.unwrapOptionField("functionList", functionList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListFunctionsResponse
  ) extends zio.aws.cloudfront.model.ListFunctionsResponse.ReadOnly {
    override val functionList
        : Option[zio.aws.cloudfront.model.FunctionList.ReadOnly] = scala
      .Option(impl.functionList())
      .map(value => zio.aws.cloudfront.model.FunctionList.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListFunctionsResponse
  ): zio.aws.cloudfront.model.ListFunctionsResponse.ReadOnly = new Wrapper(impl)
}
