package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.Timestamp
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class KeyGroup(
    id: String,
    lastModifiedTime: Timestamp,
    keyGroupConfig: zio.aws.cloudfront.model.KeyGroupConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.KeyGroup = {
    import KeyGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.KeyGroup
      .builder()
      .id(id: java.lang.String)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .keyGroupConfig(keyGroupConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.KeyGroup.ReadOnly =
    zio.aws.cloudfront.model.KeyGroup.wrap(buildAwsValue())
}
object KeyGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.KeyGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.KeyGroup = zio.aws.cloudfront.model
      .KeyGroup(id, lastModifiedTime, keyGroupConfig.asEditable)
    def id: String
    def lastModifiedTime: Timestamp
    def keyGroupConfig: zio.aws.cloudfront.model.KeyGroupConfig.ReadOnly
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getKeyGroupConfig
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.KeyGroupConfig.ReadOnly] =
      ZIO.succeed(keyGroupConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.KeyGroup
  ) extends zio.aws.cloudfront.model.KeyGroup.ReadOnly {
    override val id: String = impl.id(): String
    override val lastModifiedTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.lastModifiedTime())
    override val keyGroupConfig
        : zio.aws.cloudfront.model.KeyGroupConfig.ReadOnly =
      zio.aws.cloudfront.model.KeyGroupConfig.wrap(impl.keyGroupConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.KeyGroup
  ): zio.aws.cloudfront.model.KeyGroup.ReadOnly = new Wrapper(impl)
}
