package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetFunctionRequest(
    name: String,
    stage: Option[zio.aws.cloudfront.model.FunctionStage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetFunctionRequest = {
    import GetFunctionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetFunctionRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(stage.map(value => value.unwrap))(_.stage)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.GetFunctionRequest.ReadOnly =
    zio.aws.cloudfront.model.GetFunctionRequest.wrap(buildAwsValue())
}
object GetFunctionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetFunctionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GetFunctionRequest =
      zio.aws.cloudfront.model
        .GetFunctionRequest(name, stage.map(value => value))
    def name: String
    def stage: Option[zio.aws.cloudfront.model.FunctionStage]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getStage: ZIO[Any, AwsError, zio.aws.cloudfront.model.FunctionStage] =
      AwsError.unwrapOptionField("stage", stage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetFunctionRequest
  ) extends zio.aws.cloudfront.model.GetFunctionRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val stage: Option[zio.aws.cloudfront.model.FunctionStage] = scala
      .Option(impl.stage())
      .map(value => zio.aws.cloudfront.model.FunctionStage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetFunctionRequest
  ): zio.aws.cloudfront.model.GetFunctionRequest.ReadOnly = new Wrapper(impl)
}
