package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class FieldPatterns(
    quantity: Integer,
    items: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.FieldPatterns = {
    import FieldPatterns.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.FieldPatterns
      .builder()
      .quantity(Integer.unwrap(quantity): java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.FieldPatterns.ReadOnly =
    zio.aws.cloudfront.model.FieldPatterns.wrap(buildAwsValue())
}
object FieldPatterns {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.FieldPatterns
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.FieldPatterns =
      zio.aws.cloudfront.model
        .FieldPatterns(quantity, items.map(value => value))
    def quantity: Integer
    def items: Option[List[String]]
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.FieldPatterns
  ) extends zio.aws.cloudfront.model.FieldPatterns.ReadOnly {
    override val quantity: Integer =
      zio.aws.cloudfront.model.primitives.Integer(impl.quantity())
    override val items: Option[List[String]] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.FieldPatterns
  ): zio.aws.cloudfront.model.FieldPatterns.ReadOnly = new Wrapper(impl)
}
