package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.Timestamp
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class FieldLevelEncryption(
    id: String,
    lastModifiedTime: Timestamp,
    fieldLevelEncryptionConfig: zio.aws.cloudfront.model.FieldLevelEncryptionConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryption = {
    import FieldLevelEncryption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryption
      .builder()
      .id(id: java.lang.String)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .fieldLevelEncryptionConfig(fieldLevelEncryptionConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.FieldLevelEncryption.ReadOnly =
    zio.aws.cloudfront.model.FieldLevelEncryption.wrap(buildAwsValue())
}
object FieldLevelEncryption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.FieldLevelEncryption =
      zio.aws.cloudfront.model.FieldLevelEncryption(
        id,
        lastModifiedTime,
        fieldLevelEncryptionConfig.asEditable
      )
    def id: String
    def lastModifiedTime: Timestamp
    def fieldLevelEncryptionConfig
        : zio.aws.cloudfront.model.FieldLevelEncryptionConfig.ReadOnly
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getFieldLevelEncryptionConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.FieldLevelEncryptionConfig.ReadOnly
    ] = ZIO.succeed(fieldLevelEncryptionConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryption
  ) extends zio.aws.cloudfront.model.FieldLevelEncryption.ReadOnly {
    override val id: String = impl.id(): String
    override val lastModifiedTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.lastModifiedTime())
    override val fieldLevelEncryptionConfig
        : zio.aws.cloudfront.model.FieldLevelEncryptionConfig.ReadOnly =
      zio.aws.cloudfront.model.FieldLevelEncryptionConfig
        .wrap(impl.fieldLevelEncryptionConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryption
  ): zio.aws.cloudfront.model.FieldLevelEncryption.ReadOnly = new Wrapper(impl)
}
