package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DefaultCacheBehavior(
    targetOriginId: String,
    trustedSigners: Option[zio.aws.cloudfront.model.TrustedSigners] = None,
    trustedKeyGroups: Option[zio.aws.cloudfront.model.TrustedKeyGroups] = None,
    viewerProtocolPolicy: zio.aws.cloudfront.model.ViewerProtocolPolicy,
    allowedMethods: Option[zio.aws.cloudfront.model.AllowedMethods] = None,
    smoothStreaming: Option[Boolean] = None,
    compress: Option[Boolean] = None,
    lambdaFunctionAssociations: Option[
      zio.aws.cloudfront.model.LambdaFunctionAssociations
    ] = None,
    functionAssociations: Option[
      zio.aws.cloudfront.model.FunctionAssociations
    ] = None,
    fieldLevelEncryptionId: Option[String] = None,
    realtimeLogConfigArn: Option[String] = None,
    cachePolicyId: Option[String] = None,
    originRequestPolicyId: Option[String] = None,
    responseHeadersPolicyId: Option[String] = None,
    forwardedValues: Option[zio.aws.cloudfront.model.ForwardedValues] = None,
    minTTL: Option[Long] = None,
    defaultTTL: Option[Long] = None,
    maxTTL: Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DefaultCacheBehavior = {
    import DefaultCacheBehavior.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DefaultCacheBehavior
      .builder()
      .targetOriginId(targetOriginId: java.lang.String)
      .optionallyWith(trustedSigners.map(value => value.buildAwsValue()))(
        _.trustedSigners
      )
      .optionallyWith(trustedKeyGroups.map(value => value.buildAwsValue()))(
        _.trustedKeyGroups
      )
      .viewerProtocolPolicy(viewerProtocolPolicy.unwrap)
      .optionallyWith(allowedMethods.map(value => value.buildAwsValue()))(
        _.allowedMethods
      )
      .optionallyWith(smoothStreaming.map(value => value: java.lang.Boolean))(
        _.smoothStreaming
      )
      .optionallyWith(compress.map(value => value: java.lang.Boolean))(
        _.compress
      )
      .optionallyWith(
        lambdaFunctionAssociations.map(value => value.buildAwsValue())
      )(_.lambdaFunctionAssociations)
      .optionallyWith(functionAssociations.map(value => value.buildAwsValue()))(
        _.functionAssociations
      )
      .optionallyWith(
        fieldLevelEncryptionId.map(value => value: java.lang.String)
      )(_.fieldLevelEncryptionId)
      .optionallyWith(
        realtimeLogConfigArn.map(value => value: java.lang.String)
      )(_.realtimeLogConfigArn)
      .optionallyWith(cachePolicyId.map(value => value: java.lang.String))(
        _.cachePolicyId
      )
      .optionallyWith(
        originRequestPolicyId.map(value => value: java.lang.String)
      )(_.originRequestPolicyId)
      .optionallyWith(
        responseHeadersPolicyId.map(value => value: java.lang.String)
      )(_.responseHeadersPolicyId)
      .optionallyWith(forwardedValues.map(value => value.buildAwsValue()))(
        _.forwardedValues
      )
      .optionallyWith(minTTL.map(value => value: java.lang.Long))(_.minTTL)
      .optionallyWith(defaultTTL.map(value => value: java.lang.Long))(
        _.defaultTTL
      )
      .optionallyWith(maxTTL.map(value => value: java.lang.Long))(_.maxTTL)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.DefaultCacheBehavior.ReadOnly =
    zio.aws.cloudfront.model.DefaultCacheBehavior.wrap(buildAwsValue())
}
object DefaultCacheBehavior {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DefaultCacheBehavior
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DefaultCacheBehavior =
      zio.aws.cloudfront.model.DefaultCacheBehavior(
        targetOriginId,
        trustedSigners.map(value => value.asEditable),
        trustedKeyGroups.map(value => value.asEditable),
        viewerProtocolPolicy,
        allowedMethods.map(value => value.asEditable),
        smoothStreaming.map(value => value),
        compress.map(value => value),
        lambdaFunctionAssociations.map(value => value.asEditable),
        functionAssociations.map(value => value.asEditable),
        fieldLevelEncryptionId.map(value => value),
        realtimeLogConfigArn.map(value => value),
        cachePolicyId.map(value => value),
        originRequestPolicyId.map(value => value),
        responseHeadersPolicyId.map(value => value),
        forwardedValues.map(value => value.asEditable),
        minTTL.map(value => value),
        defaultTTL.map(value => value),
        maxTTL.map(value => value)
      )
    def targetOriginId: String
    def trustedSigners: Option[zio.aws.cloudfront.model.TrustedSigners.ReadOnly]
    def trustedKeyGroups
        : Option[zio.aws.cloudfront.model.TrustedKeyGroups.ReadOnly]
    def viewerProtocolPolicy: zio.aws.cloudfront.model.ViewerProtocolPolicy
    def allowedMethods: Option[zio.aws.cloudfront.model.AllowedMethods.ReadOnly]
    def smoothStreaming: Option[Boolean]
    def compress: Option[Boolean]
    def lambdaFunctionAssociations
        : Option[zio.aws.cloudfront.model.LambdaFunctionAssociations.ReadOnly]
    def functionAssociations
        : Option[zio.aws.cloudfront.model.FunctionAssociations.ReadOnly]
    def fieldLevelEncryptionId: Option[String]
    def realtimeLogConfigArn: Option[String]
    def cachePolicyId: Option[String]
    def originRequestPolicyId: Option[String]
    def responseHeadersPolicyId: Option[String]
    def forwardedValues
        : Option[zio.aws.cloudfront.model.ForwardedValues.ReadOnly]
    def minTTL: Option[Long]
    def defaultTTL: Option[Long]
    def maxTTL: Option[Long]
    def getTargetOriginId: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetOriginId)
    def getTrustedSigners
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.TrustedSigners.ReadOnly] =
      AwsError.unwrapOptionField("trustedSigners", trustedSigners)
    def getTrustedKeyGroups: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.TrustedKeyGroups.ReadOnly
    ] = AwsError.unwrapOptionField("trustedKeyGroups", trustedKeyGroups)
    def getViewerProtocolPolicy
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.ViewerProtocolPolicy] =
      ZIO.succeed(viewerProtocolPolicy)
    def getAllowedMethods
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.AllowedMethods.ReadOnly] =
      AwsError.unwrapOptionField("allowedMethods", allowedMethods)
    def getSmoothStreaming: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("smoothStreaming", smoothStreaming)
    def getCompress: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("compress", compress)
    def getLambdaFunctionAssociations: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.LambdaFunctionAssociations.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaFunctionAssociations",
      lambdaFunctionAssociations
    )
    def getFunctionAssociations: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.FunctionAssociations.ReadOnly
    ] = AwsError.unwrapOptionField("functionAssociations", functionAssociations)
    def getFieldLevelEncryptionId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("fieldLevelEncryptionId", fieldLevelEncryptionId)
    def getRealtimeLogConfigArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("realtimeLogConfigArn", realtimeLogConfigArn)
    def getCachePolicyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cachePolicyId", cachePolicyId)
    def getOriginRequestPolicyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("originRequestPolicyId", originRequestPolicyId)
    def getResponseHeadersPolicyId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("responseHeadersPolicyId", responseHeadersPolicyId)
    def getForwardedValues: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ForwardedValues.ReadOnly
    ] = AwsError.unwrapOptionField("forwardedValues", forwardedValues)
    def getMinTTL: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("minTTL", minTTL)
    def getDefaultTTL: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("defaultTTL", defaultTTL)
    def getMaxTTL: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("maxTTL", maxTTL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DefaultCacheBehavior
  ) extends zio.aws.cloudfront.model.DefaultCacheBehavior.ReadOnly {
    override val targetOriginId: String = impl.targetOriginId(): String
    override val trustedSigners
        : Option[zio.aws.cloudfront.model.TrustedSigners.ReadOnly] = scala
      .Option(impl.trustedSigners())
      .map(value => zio.aws.cloudfront.model.TrustedSigners.wrap(value))
    override val trustedKeyGroups
        : Option[zio.aws.cloudfront.model.TrustedKeyGroups.ReadOnly] = scala
      .Option(impl.trustedKeyGroups())
      .map(value => zio.aws.cloudfront.model.TrustedKeyGroups.wrap(value))
    override val viewerProtocolPolicy
        : zio.aws.cloudfront.model.ViewerProtocolPolicy =
      zio.aws.cloudfront.model.ViewerProtocolPolicy
        .wrap(impl.viewerProtocolPolicy())
    override val allowedMethods
        : Option[zio.aws.cloudfront.model.AllowedMethods.ReadOnly] = scala
      .Option(impl.allowedMethods())
      .map(value => zio.aws.cloudfront.model.AllowedMethods.wrap(value))
    override val smoothStreaming: Option[Boolean] =
      scala.Option(impl.smoothStreaming()).map(value => value: Boolean)
    override val compress: Option[Boolean] =
      scala.Option(impl.compress()).map(value => value: Boolean)
    override val lambdaFunctionAssociations
        : Option[zio.aws.cloudfront.model.LambdaFunctionAssociations.ReadOnly] =
      scala
        .Option(impl.lambdaFunctionAssociations())
        .map(value =>
          zio.aws.cloudfront.model.LambdaFunctionAssociations.wrap(value)
        )
    override val functionAssociations
        : Option[zio.aws.cloudfront.model.FunctionAssociations.ReadOnly] = scala
      .Option(impl.functionAssociations())
      .map(value => zio.aws.cloudfront.model.FunctionAssociations.wrap(value))
    override val fieldLevelEncryptionId: Option[String] =
      scala.Option(impl.fieldLevelEncryptionId()).map(value => value: String)
    override val realtimeLogConfigArn: Option[String] =
      scala.Option(impl.realtimeLogConfigArn()).map(value => value: String)
    override val cachePolicyId: Option[String] =
      scala.Option(impl.cachePolicyId()).map(value => value: String)
    override val originRequestPolicyId: Option[String] =
      scala.Option(impl.originRequestPolicyId()).map(value => value: String)
    override val responseHeadersPolicyId: Option[String] =
      scala.Option(impl.responseHeadersPolicyId()).map(value => value: String)
    override val forwardedValues
        : Option[zio.aws.cloudfront.model.ForwardedValues.ReadOnly] = scala
      .Option(impl.forwardedValues())
      .map(value => zio.aws.cloudfront.model.ForwardedValues.wrap(value))
    override val minTTL: Option[Long] =
      scala.Option(impl.minTTL()).map(value => value: Long)
    override val defaultTTL: Option[Long] =
      scala.Option(impl.defaultTTL()).map(value => value: Long)
    override val maxTTL: Option[Long] =
      scala.Option(impl.maxTTL()).map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DefaultCacheBehavior
  ): zio.aws.cloudfront.model.DefaultCacheBehavior.ReadOnly = new Wrapper(impl)
}
