package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDistributionsByVpcOriginIdResponse(
    distributionIdList: Optional[zio.aws.cloudfront.model.DistributionIdList] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListDistributionsByVpcOriginIdResponse = {
    import ListDistributionsByVpcOriginIdResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByVpcOriginIdResponse
      .builder()
      .optionallyWith(distributionIdList.map(value => value.buildAwsValue()))(
        _.distributionIdList
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListDistributionsByVpcOriginIdResponse.ReadOnly =
    zio.aws.cloudfront.model.ListDistributionsByVpcOriginIdResponse
      .wrap(buildAwsValue())
}
object ListDistributionsByVpcOriginIdResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByVpcOriginIdResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListDistributionsByVpcOriginIdResponse =
      zio.aws.cloudfront.model.ListDistributionsByVpcOriginIdResponse(
        distributionIdList.map(value => value.asEditable)
      )
    def distributionIdList
        : Optional[zio.aws.cloudfront.model.DistributionIdList.ReadOnly]
    def getDistributionIdList: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.DistributionIdList.ReadOnly
    ] = AwsError.unwrapOptionField("distributionIdList", distributionIdList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByVpcOriginIdResponse
  ) extends zio.aws.cloudfront.model.ListDistributionsByVpcOriginIdResponse.ReadOnly {
    override val distributionIdList
        : Optional[zio.aws.cloudfront.model.DistributionIdList.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.distributionIdList())
        .map(value => zio.aws.cloudfront.model.DistributionIdList.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByVpcOriginIdResponse
  ): zio.aws.cloudfront.model.ListDistributionsByVpcOriginIdResponse.ReadOnly =
    new Wrapper(impl)
}
