package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFieldLevelEncryptionProfilesResponse(
    fieldLevelEncryptionProfileList: Optional[
      zio.aws.cloudfront.model.FieldLevelEncryptionProfileList
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesResponse = {
    import ListFieldLevelEncryptionProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesResponse
      .builder()
      .optionallyWith(
        fieldLevelEncryptionProfileList.map(value => value.buildAwsValue())
      )(_.fieldLevelEncryptionProfileList)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListFieldLevelEncryptionProfilesResponse.ReadOnly =
    zio.aws.cloudfront.model.ListFieldLevelEncryptionProfilesResponse
      .wrap(buildAwsValue())
}
object ListFieldLevelEncryptionProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListFieldLevelEncryptionProfilesResponse =
      zio.aws.cloudfront.model.ListFieldLevelEncryptionProfilesResponse(
        fieldLevelEncryptionProfileList.map(value => value.asEditable)
      )
    def fieldLevelEncryptionProfileList: Optional[
      zio.aws.cloudfront.model.FieldLevelEncryptionProfileList.ReadOnly
    ]
    def getFieldLevelEncryptionProfileList: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.FieldLevelEncryptionProfileList.ReadOnly
    ] = AwsError.unwrapOptionField(
      "fieldLevelEncryptionProfileList",
      fieldLevelEncryptionProfileList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesResponse
  ) extends zio.aws.cloudfront.model.ListFieldLevelEncryptionProfilesResponse.ReadOnly {
    override val fieldLevelEncryptionProfileList: Optional[
      zio.aws.cloudfront.model.FieldLevelEncryptionProfileList.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fieldLevelEncryptionProfileList())
      .map(value =>
        zio.aws.cloudfront.model.FieldLevelEncryptionProfileList.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesResponse
  ): zio.aws.cloudfront.model.ListFieldLevelEncryptionProfilesResponse.ReadOnly =
    new Wrapper(impl)
}
