package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDistributionsByCachePolicyIdResponse(
    distributionIdList: Optional[zio.aws.cloudfront.model.DistributionIdList] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListDistributionsByCachePolicyIdResponse = {
    import ListDistributionsByCachePolicyIdResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByCachePolicyIdResponse
      .builder()
      .optionallyWith(distributionIdList.map(value => value.buildAwsValue()))(
        _.distributionIdList
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListDistributionsByCachePolicyIdResponse.ReadOnly =
    zio.aws.cloudfront.model.ListDistributionsByCachePolicyIdResponse
      .wrap(buildAwsValue())
}
object ListDistributionsByCachePolicyIdResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByCachePolicyIdResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListDistributionsByCachePolicyIdResponse =
      zio.aws.cloudfront.model.ListDistributionsByCachePolicyIdResponse(
        distributionIdList.map(value => value.asEditable)
      )
    def distributionIdList
        : Optional[zio.aws.cloudfront.model.DistributionIdList.ReadOnly]
    def getDistributionIdList: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.DistributionIdList.ReadOnly
    ] = AwsError.unwrapOptionField("distributionIdList", distributionIdList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByCachePolicyIdResponse
  ) extends zio.aws.cloudfront.model.ListDistributionsByCachePolicyIdResponse.ReadOnly {
    override val distributionIdList
        : Optional[zio.aws.cloudfront.model.DistributionIdList.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.distributionIdList())
        .map(value => zio.aws.cloudfront.model.DistributionIdList.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByCachePolicyIdResponse
  ): zio.aws.cloudfront.model.ListDistributionsByCachePolicyIdResponse.ReadOnly =
    new Wrapper(impl)
}
