package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait FunctionRuntime {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.FunctionRuntime
}
object FunctionRuntime {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.FunctionRuntime
  ): zio.aws.cloudfront.model.FunctionRuntime = value match {
    case software.amazon.awssdk.services.cloudfront.model.FunctionRuntime.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.FunctionRuntime.CLOUDFRONT_JS_1_0 =>
      val r = `cloudfront-js-1.0`
      r
    case software.amazon.awssdk.services.cloudfront.model.FunctionRuntime.CLOUDFRONT_JS_2_0 =>
      val r = `cloudfront-js-2.0`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.FunctionRuntime {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.FunctionRuntime =
      software.amazon.awssdk.services.cloudfront.model.FunctionRuntime.UNKNOWN_TO_SDK_VERSION
  }
  case object `cloudfront-js-1.0`
      extends zio.aws.cloudfront.model.FunctionRuntime {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.FunctionRuntime =
      software.amazon.awssdk.services.cloudfront.model.FunctionRuntime.CLOUDFRONT_JS_1_0
  }
  case object `cloudfront-js-2.0`
      extends zio.aws.cloudfront.model.FunctionRuntime {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.FunctionRuntime =
      software.amazon.awssdk.services.cloudfront.model.FunctionRuntime.CLOUDFRONT_JS_2_0
  }
}
