package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.ResourceARN
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resource: ResourceARN,
    tags: zio.aws.cloudfront.model.Tags
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.TagResourceRequest
      .builder()
      .resource(ResourceARN.unwrap(resource): java.lang.String)
      .tags(tags.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.TagResourceRequest.ReadOnly =
    zio.aws.cloudfront.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.TagResourceRequest =
      zio.aws.cloudfront.model.TagResourceRequest(resource, tags.asEditable)
    def resource: ResourceARN
    def tags: zio.aws.cloudfront.model.Tags.ReadOnly
    def getResource: ZIO[Any, Nothing, ResourceARN] = ZIO.succeed(resource)
    def getTags: ZIO[Any, Nothing, zio.aws.cloudfront.model.Tags.ReadOnly] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.TagResourceRequest
  ) extends zio.aws.cloudfront.model.TagResourceRequest.ReadOnly {
    override val resource: ResourceARN =
      zio.aws.cloudfront.model.primitives.ResourceARN(impl.resource())
    override val tags: zio.aws.cloudfront.model.Tags.ReadOnly =
      zio.aws.cloudfront.model.Tags.wrap(impl.tags())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.TagResourceRequest
  ): zio.aws.cloudfront.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
