package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListKeyValueStoresResponse(
    keyValueStoreList: Optional[zio.aws.cloudfront.model.KeyValueStoreList] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListKeyValueStoresResponse = {
    import ListKeyValueStoresResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListKeyValueStoresResponse
      .builder()
      .optionallyWith(keyValueStoreList.map(value => value.buildAwsValue()))(
        _.keyValueStoreList
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ListKeyValueStoresResponse.ReadOnly =
    zio.aws.cloudfront.model.ListKeyValueStoresResponse.wrap(buildAwsValue())
}
object ListKeyValueStoresResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListKeyValueStoresResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListKeyValueStoresResponse =
      zio.aws.cloudfront.model.ListKeyValueStoresResponse(
        keyValueStoreList.map(value => value.asEditable)
      )
    def keyValueStoreList
        : Optional[zio.aws.cloudfront.model.KeyValueStoreList.ReadOnly]
    def getKeyValueStoreList: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.KeyValueStoreList.ReadOnly
    ] = AwsError.unwrapOptionField("keyValueStoreList", keyValueStoreList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListKeyValueStoresResponse
  ) extends zio.aws.cloudfront.model.ListKeyValueStoresResponse.ReadOnly {
    override val keyValueStoreList
        : Optional[zio.aws.cloudfront.model.KeyValueStoreList.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyValueStoreList())
        .map(value => zio.aws.cloudfront.model.KeyValueStoreList.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListKeyValueStoresResponse
  ): zio.aws.cloudfront.model.ListKeyValueStoresResponse.ReadOnly = new Wrapper(
    impl
  )
}
