package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ImportSource(
    sourceType: zio.aws.cloudfront.model.ImportSourceType,
    sourceARN: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ImportSource = {
    import ImportSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ImportSource
      .builder()
      .sourceType(sourceType.unwrap)
      .sourceARN(sourceARN: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ImportSource.ReadOnly =
    zio.aws.cloudfront.model.ImportSource.wrap(buildAwsValue())
}
object ImportSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ImportSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ImportSource =
      zio.aws.cloudfront.model.ImportSource(sourceType, sourceARN)
    def sourceType: zio.aws.cloudfront.model.ImportSourceType
    def sourceARN: String
    def getSourceType
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.ImportSourceType] =
      ZIO.succeed(sourceType)
    def getSourceARN: ZIO[Any, Nothing, String] = ZIO.succeed(sourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ImportSource
  ) extends zio.aws.cloudfront.model.ImportSource.ReadOnly {
    override val sourceType: zio.aws.cloudfront.model.ImportSourceType =
      zio.aws.cloudfront.model.ImportSourceType.wrap(impl.sourceType())
    override val sourceARN: String = impl.sourceARN(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ImportSource
  ): zio.aws.cloudfront.model.ImportSource.ReadOnly = new Wrapper(impl)
}
