package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.{FunctionBlob, FunctionName}
import scala.jdk.CollectionConverters._
final case class CreateFunctionRequest(
    name: FunctionName,
    functionConfig: zio.aws.cloudfront.model.FunctionConfig,
    functionCode: FunctionBlob
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateFunctionRequest = {
    import CreateFunctionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateFunctionRequest
      .builder()
      .name(FunctionName.unwrap(name): java.lang.String)
      .functionConfig(functionConfig.buildAwsValue())
      .functionCode(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(functionCode.toArray[Byte])
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CreateFunctionRequest.ReadOnly =
    zio.aws.cloudfront.model.CreateFunctionRequest.wrap(buildAwsValue())
}
object CreateFunctionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateFunctionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateFunctionRequest =
      zio.aws.cloudfront.model
        .CreateFunctionRequest(name, functionConfig.asEditable, functionCode)
    def name: FunctionName
    def functionConfig: zio.aws.cloudfront.model.FunctionConfig.ReadOnly
    def functionCode: FunctionBlob
    def getName: ZIO[Any, Nothing, FunctionName] = ZIO.succeed(name)
    def getFunctionConfig
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.FunctionConfig.ReadOnly] =
      ZIO.succeed(functionConfig)
    def getFunctionCode: ZIO[Any, Nothing, FunctionBlob] =
      ZIO.succeed(functionCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateFunctionRequest
  ) extends zio.aws.cloudfront.model.CreateFunctionRequest.ReadOnly {
    override val name: FunctionName =
      zio.aws.cloudfront.model.primitives.FunctionName(impl.name())
    override val functionConfig
        : zio.aws.cloudfront.model.FunctionConfig.ReadOnly =
      zio.aws.cloudfront.model.FunctionConfig.wrap(impl.functionConfig())
    override val functionCode: FunctionBlob =
      zio.aws.cloudfront.model.primitives.FunctionBlob(
        zio.Chunk.fromArray(impl.functionCode().asByteArrayUnsafe())
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateFunctionRequest
  ): zio.aws.cloudfront.model.CreateFunctionRequest.ReadOnly = new Wrapper(impl)
}
