package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAnycastIpListResponse(
    anycastIpList: Optional[zio.aws.cloudfront.model.AnycastIpList] =
      Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateAnycastIpListResponse = {
    import CreateAnycastIpListResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateAnycastIpListResponse
      .builder()
      .optionallyWith(anycastIpList.map(value => value.buildAwsValue()))(
        _.anycastIpList
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateAnycastIpListResponse.ReadOnly =
    zio.aws.cloudfront.model.CreateAnycastIpListResponse.wrap(buildAwsValue())
}
object CreateAnycastIpListResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateAnycastIpListResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateAnycastIpListResponse =
      zio.aws.cloudfront.model.CreateAnycastIpListResponse(
        anycastIpList.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def anycastIpList: Optional[zio.aws.cloudfront.model.AnycastIpList.ReadOnly]
    def eTag: Optional[String]
    def getAnycastIpList
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.AnycastIpList.ReadOnly] =
      AwsError.unwrapOptionField("anycastIpList", anycastIpList)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateAnycastIpListResponse
  ) extends zio.aws.cloudfront.model.CreateAnycastIpListResponse.ReadOnly {
    override val anycastIpList
        : Optional[zio.aws.cloudfront.model.AnycastIpList.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.anycastIpList())
        .map(value => zio.aws.cloudfront.model.AnycastIpList.wrap(value))
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateAnycastIpListResponse
  ): zio.aws.cloudfront.model.CreateAnycastIpListResponse.ReadOnly =
    new Wrapper(impl)
}
