package zio.aws.cloudfront
import zio.aws.cloudfront.model.ListDistributionsByVpcOriginIdResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.cloudfront.{
  CloudFrontAsyncClientBuilder,
  CloudFrontAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.aws.cloudfront.model.{
  UpdateDistributionWithStagingConfigRequest,
  ListFieldLevelEncryptionProfilesRequest,
  ListDistributionsRequest,
  GetAnycastIpListRequest,
  GetFieldLevelEncryptionProfileConfigRequest,
  CreateDistributionRequest,
  ListKeyValueStoresRequest,
  CreateResponseHeadersPolicyRequest,
  CreateOriginRequestPolicyRequest,
  DescribeFunctionRequest,
  CreateFieldLevelEncryptionProfileRequest,
  DeleteCloudFrontOriginAccessIdentityRequest,
  GetCloudFrontOriginAccessIdentityConfigRequest,
  GetMonitoringSubscriptionRequest,
  CreateInvalidationRequest,
  CreateRealtimeLogConfigRequest,
  UpdateContinuousDeploymentPolicyRequest,
  DeleteDistributionRequest,
  GetFieldLevelEncryptionProfileRequest,
  ListPublicKeysRequest,
  UpdateFieldLevelEncryptionConfigRequest,
  CreateVpcOriginRequest,
  CreateCachePolicyRequest,
  UpdateKeyValueStoreRequest,
  ListInvalidationsRequest,
  DeleteVpcOriginRequest,
  GetResponseHeadersPolicyConfigRequest,
  GetFunctionRequest,
  GetRealtimeLogConfigRequest,
  UpdateKeyGroupRequest,
  DeleteAnycastIpListRequest,
  DeleteFieldLevelEncryptionConfigRequest,
  CopyDistributionRequest,
  ListDistributionsByResponseHeadersPolicyIdRequest,
  ListDistributionsByWebAclIdRequest,
  ListDistributionsByOriginRequestPolicyIdRequest,
  DeleteFunctionRequest,
  CreateOriginAccessControlRequest,
  GetOriginRequestPolicyConfigRequest,
  DeletePublicKeyRequest,
  ListDistributionsByCachePolicyIdRequest,
  UpdateOriginAccessControlRequest,
  GetDistributionConfigRequest,
  GetOriginAccessControlConfigRequest,
  ListResponseHeadersPoliciesRequest,
  ListVpcOriginsRequest,
  ListTagsForResourceRequest,
  UpdateRealtimeLogConfigRequest,
  GetVpcOriginRequest,
  GetCachePolicyRequest,
  GetStreamingDistributionRequest,
  ListOriginAccessControlsRequest,
  ListAnycastIpListsRequest,
  GetDistributionRequest,
  GetContinuousDeploymentPolicyRequest,
  AssociateAliasRequest,
  TestFunctionRequest,
  DeleteResponseHeadersPolicyRequest,
  ListStreamingDistributionsRequest,
  ListFieldLevelEncryptionConfigsRequest,
  CreateContinuousDeploymentPolicyRequest,
  CreateDistributionWithTagsRequest,
  CreateKeyGroupRequest,
  GetKeyGroupRequest,
  CreateFieldLevelEncryptionConfigRequest,
  GetInvalidationRequest,
  DeleteCachePolicyRequest,
  CreateKeyValueStoreRequest,
  CreateMonitoringSubscriptionRequest,
  UpdateDistributionRequest,
  CreateFunctionRequest,
  GetCloudFrontOriginAccessIdentityRequest,
  PublishFunctionRequest,
  GetResponseHeadersPolicyRequest,
  CreateStreamingDistributionWithTagsRequest,
  UpdateVpcOriginRequest,
  ListContinuousDeploymentPoliciesRequest,
  ListFunctionsRequest,
  UntagResourceRequest,
  UpdateResponseHeadersPolicyRequest,
  DeleteOriginRequestPolicyRequest,
  ListRealtimeLogConfigsRequest,
  DeleteFieldLevelEncryptionProfileRequest,
  GetContinuousDeploymentPolicyConfigRequest,
  GetFieldLevelEncryptionRequest,
  DescribeKeyValueStoreRequest,
  UpdateFunctionRequest,
  ListCachePoliciesRequest,
  GetKeyGroupConfigRequest,
  ListConflictingAliasesRequest,
  UpdateCloudFrontOriginAccessIdentityRequest,
  ListCloudFrontOriginAccessIdentitiesRequest,
  UpdateFieldLevelEncryptionProfileRequest,
  GetStreamingDistributionConfigRequest,
  UpdateStreamingDistributionRequest,
  ListOriginRequestPoliciesRequest,
  ListDistributionsByKeyGroupRequest,
  UpdateCachePolicyRequest,
  GetCachePolicyConfigRequest,
  GetOriginRequestPolicyRequest,
  UpdatePublicKeyRequest,
  DeleteKeyGroupRequest,
  ListDistributionsByRealtimeLogConfigRequest,
  GetPublicKeyRequest,
  GetOriginAccessControlRequest,
  GetPublicKeyConfigRequest,
  DeleteStreamingDistributionRequest,
  DeleteContinuousDeploymentPolicyRequest,
  CreateCloudFrontOriginAccessIdentityRequest,
  ListKeyGroupsRequest,
  DeleteOriginAccessControlRequest,
  CreateAnycastIpListRequest,
  GetFieldLevelEncryptionConfigRequest,
  ListDistributionsByAnycastIpListIdRequest,
  ListDistributionsByVpcOriginIdRequest,
  DeleteRealtimeLogConfigRequest,
  DeleteKeyValueStoreRequest,
  TagResourceRequest,
  CreatePublicKeyRequest,
  DeleteMonitoringSubscriptionRequest,
  UpdateOriginRequestPolicyRequest,
  CreateStreamingDistributionRequest
}
import software.amazon.awssdk.services.cloudfront.model.{
  CreateResponseHeadersPolicyResponse,
  CreateAnycastIpListResponse,
  ListOriginRequestPoliciesResponse,
  GetPublicKeyConfigResponse,
  GetFieldLevelEncryptionConfigResponse,
  DeleteStreamingDistributionResponse,
  GetVpcOriginResponse,
  CreateVpcOriginResponse,
  ListPublicKeysResponse,
  CreateStreamingDistributionWithTagsResponse,
  UpdateContinuousDeploymentPolicyResponse,
  UpdateCachePolicyResponse,
  GetResponseHeadersPolicyConfigResponse,
  GetStreamingDistributionResponse,
  ListDistributionsByOriginRequestPolicyIdResponse,
  ListConflictingAliasesResponse,
  CreateContinuousDeploymentPolicyResponse,
  GetCloudFrontOriginAccessIdentityResponse,
  DescribeKeyValueStoreResponse,
  CreateFieldLevelEncryptionConfigResponse,
  DeleteFieldLevelEncryptionProfileResponse,
  GetContinuousDeploymentPolicyResponse,
  GetResponseHeadersPolicyResponse,
  GetOriginRequestPolicyConfigResponse,
  CreatePublicKeyResponse,
  ListDistributionsByRealtimeLogConfigResponse,
  UpdateRealtimeLogConfigResponse,
  ListStreamingDistributionsResponse,
  GetCachePolicyResponse,
  DeleteKeyGroupResponse,
  ListFieldLevelEncryptionProfilesResponse,
  ListInvalidationsResponse,
  ListDistributionsResponse,
  DeleteVpcOriginResponse,
  ListAnycastIpListsResponse,
  GetKeyGroupResponse,
  DescribeFunctionResponse,
  ListKeyValueStoresResponse,
  ListRealtimeLogConfigsResponse,
  UpdateCloudFrontOriginAccessIdentityResponse,
  UpdateKeyValueStoreResponse,
  DeleteCloudFrontOriginAccessIdentityResponse,
  GetAnycastIpListResponse,
  CreateDistributionWithTagsResponse,
  ListCachePoliciesResponse,
  ListDistributionsByKeyGroupResponse,
  GetDistributionResponse,
  ListResponseHeadersPoliciesResponse,
  DeleteAnycastIpListResponse,
  GetCloudFrontOriginAccessIdentityConfigResponse,
  ListVpcOriginsResponse,
  UpdateVpcOriginResponse,
  DeleteMonitoringSubscriptionResponse,
  GetFieldLevelEncryptionProfileResponse,
  ListContinuousDeploymentPoliciesResponse,
  ListDistributionsByAnycastIpListIdResponse,
  DeleteDistributionResponse,
  CreateStreamingDistributionResponse,
  ListFunctionsResponse,
  CreateRealtimeLogConfigResponse,
  GetKeyGroupConfigResponse,
  UpdatePublicKeyResponse,
  DeleteResponseHeadersPolicyResponse,
  CreateMonitoringSubscriptionResponse,
  GetStreamingDistributionConfigResponse,
  ListTagsForResourceResponse,
  CopyDistributionResponse,
  UntagResourceResponse,
  ListCloudFrontOriginAccessIdentitiesResponse,
  ListDistributionsByWebAclIdResponse,
  UpdateDistributionResponse,
  GetRealtimeLogConfigResponse,
  GetFunctionResponse,
  GetInvalidationResponse,
  DeleteKeyValueStoreResponse,
  UpdateFieldLevelEncryptionConfigResponse,
  GetFieldLevelEncryptionResponse,
  UpdateFieldLevelEncryptionProfileResponse,
  CreateOriginAccessControlResponse,
  PublishFunctionResponse,
  GetCachePolicyConfigResponse,
  GetDistributionConfigResponse,
  GetOriginAccessControlConfigResponse,
  CreateCachePolicyResponse,
  DeleteCachePolicyResponse,
  GetContinuousDeploymentPolicyConfigResponse,
  ListDistributionsByVpcOriginIdResponse,
  UpdateStreamingDistributionResponse,
  GetPublicKeyResponse,
  UpdateFunctionResponse,
  CreateFunctionResponse,
  UpdateOriginRequestPolicyResponse,
  GetOriginAccessControlResponse,
  AssociateAliasResponse,
  TestFunctionResponse,
  CreateFieldLevelEncryptionProfileResponse,
  ListFieldLevelEncryptionConfigsResponse,
  DeleteRealtimeLogConfigResponse,
  DeleteOriginAccessControlResponse,
  UpdateOriginAccessControlResponse,
  CreateKeyValueStoreResponse,
  CreateInvalidationResponse,
  CreateKeyGroupResponse,
  UpdateResponseHeadersPolicyResponse,
  DeleteFieldLevelEncryptionConfigResponse,
  UpdateDistributionWithStagingConfigResponse,
  GetOriginRequestPolicyResponse,
  CreateDistributionResponse,
  ListDistributionsByResponseHeadersPolicyIdResponse,
  DeleteFunctionResponse,
  TagResourceResponse,
  UpdateKeyGroupResponse,
  ListOriginAccessControlsResponse,
  ListKeyGroupsResponse,
  CreateOriginRequestPolicyResponse,
  DeleteOriginRequestPolicyResponse,
  DeletePublicKeyResponse,
  DeleteContinuousDeploymentPolicyResponse,
  GetFieldLevelEncryptionProfileConfigResponse,
  GetMonitoringSubscriptionResponse,
  CreateCloudFrontOriginAccessIdentityResponse,
  ListDistributionsByCachePolicyIdResponse
}
import scala.jdk.CollectionConverters._
trait CloudFront extends AspectSupport[CloudFront] {
  val api: CloudFrontAsyncClient
  def listResponseHeadersPolicies(
      request: ListResponseHeadersPoliciesRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.ListResponseHeadersPoliciesResponse.ReadOnly
  ]
  def getInvalidation(
      request: GetInvalidationRequest
  ): IO[AwsError, zio.aws.cloudfront.model.GetInvalidationResponse.ReadOnly]
  def deleteKeyGroup(request: DeleteKeyGroupRequest): IO[AwsError, Unit]
  def updateOriginAccessControl(request: UpdateOriginAccessControlRequest): IO[
    AwsError,
    zio.aws.cloudfront.model.UpdateOriginAccessControlResponse.ReadOnly
  ]
  def createMonitoringSubscription(
      request: CreateMonitoringSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.CreateMonitoringSubscriptionResponse.ReadOnly
  ]
  def getRealtimeLogConfig(request: GetRealtimeLogConfigRequest): IO[
    AwsError,
    zio.aws.cloudfront.model.GetRealtimeLogConfigResponse.ReadOnly
  ]
  def createStreamingDistribution(
      request: CreateStreamingDistributionRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.CreateStreamingDistributionResponse.ReadOnly
  ]
  def testFunction(
      request: TestFunctionRequest
  ): IO[AwsError, zio.aws.cloudfront.model.TestFunctionResponse.ReadOnly]
  def getFieldLevelEncryptionProfile(
      request: GetFieldLevelEncryptionProfileRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.GetFieldLevelEncryptionProfileResponse.ReadOnly
  ]
  def getContinuousDeploymentPolicy(
      request: GetContinuousDeploymentPolicyRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.GetContinuousDeploymentPolicyResponse.ReadOnly
  ]
  def listDistributionsByWebACLId(
      request: ListDistributionsByWebAclIdRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.ListDistributionsByWebAclIdResponse.ReadOnly
  ]
  def deleteCloudFrontOriginAccessIdentity(
      request: DeleteCloudFrontOriginAccessIdentityRequest
  ): IO[AwsError, Unit]
  def createRealtimeLogConfig(request: CreateRealtimeLogConfigRequest): IO[
    AwsError,
    zio.aws.cloudfront.model.CreateRealtimeLogConfigResponse.ReadOnly
  ]
  def listPublicKeys(
      request: ListPublicKeysRequest
  ): IO[AwsError, zio.aws.cloudfront.model.ListPublicKeysResponse.ReadOnly]
  def createOriginAccessControl(request: CreateOriginAccessControlRequest): IO[
    AwsError,
    zio.aws.cloudfront.model.CreateOriginAccessControlResponse.ReadOnly
  ]
  def getKeyGroup(
      request: GetKeyGroupRequest
  ): IO[AwsError, zio.aws.cloudfront.model.GetKeyGroupResponse.ReadOnly]
  def getOriginAccessControl(request: GetOriginAccessControlRequest): IO[
    AwsError,
    zio.aws.cloudfront.model.GetOriginAccessControlResponse.ReadOnly
  ]
  def createStreamingDistributionWithTags(
      request: CreateStreamingDistributionWithTagsRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.CreateStreamingDistributionWithTagsResponse.ReadOnly
  ]
  def listConflictingAliases(request: ListConflictingAliasesRequest): IO[
    AwsError,
    zio.aws.cloudfront.model.ListConflictingAliasesResponse.ReadOnly
  ]
  def listDistributionsByOriginRequestPolicyId(
      request: ListDistributionsByOriginRequestPolicyIdRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.ListDistributionsByOriginRequestPolicyIdResponse.ReadOnly
  ]
  def deleteCachePolicy(request: DeleteCachePolicyRequest): IO[AwsError, Unit]
  def deleteKeyValueStore(
      request: DeleteKeyValueStoreRequest
  ): IO[AwsError, Unit]
  def createDistributionWithTags(
      request: CreateDistributionWithTagsRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.CreateDistributionWithTagsResponse.ReadOnly
  ]
  def deleteVpcOrigin(
      request: DeleteVpcOriginRequest
  ): IO[AwsError, zio.aws.cloudfront.model.DeleteVpcOriginResponse.ReadOnly]
  def getFieldLevelEncryptionConfig(
      request: GetFieldLevelEncryptionConfigRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.GetFieldLevelEncryptionConfigResponse.ReadOnly
  ]
  def deleteOriginAccessControl(
      request: DeleteOriginAccessControlRequest
  ): IO[AwsError, Unit]
  def copyDistribution(
      request: CopyDistributionRequest
  ): IO[AwsError, zio.aws.cloudfront.model.CopyDistributionResponse.ReadOnly]
  def getAnycastIpList(
      request: GetAnycastIpListRequest
  ): IO[AwsError, zio.aws.cloudfront.model.GetAnycastIpListResponse.ReadOnly]
  def updateRealtimeLogConfig(request: UpdateRealtimeLogConfigRequest): IO[
    AwsError,
    zio.aws.cloudfront.model.UpdateRealtimeLogConfigResponse.ReadOnly
  ]
  def listCachePolicies(
      request: ListCachePoliciesRequest
  ): IO[AwsError, zio.aws.cloudfront.model.ListCachePoliciesResponse.ReadOnly]
  def createContinuousDeploymentPolicy(
      request: CreateContinuousDeploymentPolicyRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.CreateContinuousDeploymentPolicyResponse.ReadOnly
  ]
  def getVpcOrigin(
      request: GetVpcOriginRequest
  ): IO[AwsError, zio.aws.cloudfront.model.GetVpcOriginResponse.ReadOnly]
  def listFieldLevelEncryptionConfigs(
      request: ListFieldLevelEncryptionConfigsRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.ListFieldLevelEncryptionConfigsResponse.ReadOnly
  ]
  def deletePublicKey(request: DeletePublicKeyRequest): IO[AwsError, Unit]
  def getContinuousDeploymentPolicyConfig(
      request: GetContinuousDeploymentPolicyConfigRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.GetContinuousDeploymentPolicyConfigResponse.ReadOnly
  ]
  def listOriginRequestPolicies(request: ListOriginRequestPoliciesRequest): IO[
    AwsError,
    zio.aws.cloudfront.model.ListOriginRequestPoliciesResponse.ReadOnly
  ]
  def listOriginAccessControls(request: ListOriginAccessControlsRequest): IO[
    AwsError,
    zio.aws.cloudfront.model.ListOriginAccessControlsResponse.ReadOnly
  ]
  def getPublicKey(
      request: GetPublicKeyRequest
  ): IO[AwsError, zio.aws.cloudfront.model.GetPublicKeyResponse.ReadOnly]
  def getStreamingDistribution(request: GetStreamingDistributionRequest): IO[
    AwsError,
    zio.aws.cloudfront.model.GetStreamingDistributionResponse.ReadOnly
  ]
  def updateStreamingDistribution(
      request: UpdateStreamingDistributionRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.UpdateStreamingDistributionResponse.ReadOnly
  ]
  def createCachePolicy(
      request: CreateCachePolicyRequest
  ): IO[AwsError, zio.aws.cloudfront.model.CreateCachePolicyResponse.ReadOnly]
  def deleteFieldLevelEncryptionConfig(
      request: DeleteFieldLevelEncryptionConfigRequest
  ): IO[AwsError, Unit]
  def getPublicKeyConfig(
      request: GetPublicKeyConfigRequest
  ): IO[AwsError, zio.aws.cloudfront.model.GetPublicKeyConfigResponse.ReadOnly]
  def describeFunction(
      request: DescribeFunctionRequest
  ): IO[AwsError, zio.aws.cloudfront.model.DescribeFunctionResponse.ReadOnly]
  def deleteContinuousDeploymentPolicy(
      request: DeleteContinuousDeploymentPolicyRequest
  ): IO[AwsError, Unit]
  def updateResponseHeadersPolicy(
      request: UpdateResponseHeadersPolicyRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.UpdateResponseHeadersPolicyResponse.ReadOnly
  ]
  def listContinuousDeploymentPolicies(
      request: ListContinuousDeploymentPoliciesRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.ListContinuousDeploymentPoliciesResponse.ReadOnly
  ]
  def listFieldLevelEncryptionProfiles(
      request: ListFieldLevelEncryptionProfilesRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.ListFieldLevelEncryptionProfilesResponse.ReadOnly
  ]
  def getOriginRequestPolicy(request: GetOriginRequestPolicyRequest): IO[
    AwsError,
    zio.aws.cloudfront.model.GetOriginRequestPolicyResponse.ReadOnly
  ]
  def deleteFunction(request: DeleteFunctionRequest): IO[AwsError, Unit]
  def createFieldLevelEncryptionConfig(
      request: CreateFieldLevelEncryptionConfigRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.CreateFieldLevelEncryptionConfigResponse.ReadOnly
  ]
  def listDistributionsByAnycastIpListId(
      request: ListDistributionsByAnycastIpListIdRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.ListDistributionsByAnycastIpListIdResponse.ReadOnly
  ]
  def getFieldLevelEncryptionProfileConfig(
      request: GetFieldLevelEncryptionProfileConfigRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse.ReadOnly
  ]
  def getCloudFrontOriginAccessIdentity(
      request: GetCloudFrontOriginAccessIdentityRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse.ReadOnly
  ]
  def createKeyGroup(
      request: CreateKeyGroupRequest
  ): IO[AwsError, zio.aws.cloudfront.model.CreateKeyGroupResponse.ReadOnly]
  def getMonitoringSubscription(request: GetMonitoringSubscriptionRequest): IO[
    AwsError,
    zio.aws.cloudfront.model.GetMonitoringSubscriptionResponse.ReadOnly
  ]
  def listDistributions(
      request: ListDistributionsRequest
  ): IO[AwsError, zio.aws.cloudfront.model.ListDistributionsResponse.ReadOnly]
  def deleteStreamingDistribution(
      request: DeleteStreamingDistributionRequest
  ): IO[AwsError, Unit]
  def listStreamingDistributions(
      request: ListStreamingDistributionsRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.ListStreamingDistributionsResponse.ReadOnly
  ]
  def describeKeyValueStore(request: DescribeKeyValueStoreRequest): IO[
    AwsError,
    zio.aws.cloudfront.model.DescribeKeyValueStoreResponse.ReadOnly
  ]
  def listRealtimeLogConfigs(request: ListRealtimeLogConfigsRequest): IO[
    AwsError,
    zio.aws.cloudfront.model.ListRealtimeLogConfigsResponse.ReadOnly
  ]
  def untagResource(request: UntagResourceRequest): IO[AwsError, Unit]
  def deleteOriginRequestPolicy(
      request: DeleteOriginRequestPolicyRequest
  ): IO[AwsError, Unit]
  def deleteRealtimeLogConfig(
      request: DeleteRealtimeLogConfigRequest
  ): IO[AwsError, Unit]
  def deleteResponseHeadersPolicy(
      request: DeleteResponseHeadersPolicyRequest
  ): IO[AwsError, Unit]
  def updateFunction(
      request: UpdateFunctionRequest
  ): IO[AwsError, zio.aws.cloudfront.model.UpdateFunctionResponse.ReadOnly]
  def createInvalidation(
      request: CreateInvalidationRequest
  ): IO[AwsError, zio.aws.cloudfront.model.CreateInvalidationResponse.ReadOnly]
  def listDistributionsByRealtimeLogConfig(
      request: ListDistributionsByRealtimeLogConfigRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.ListDistributionsByRealtimeLogConfigResponse.ReadOnly
  ]
  def getResponseHeadersPolicyConfig(
      request: GetResponseHeadersPolicyConfigRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.GetResponseHeadersPolicyConfigResponse.ReadOnly
  ]
  def getDistributionConfig(request: GetDistributionConfigRequest): IO[
    AwsError,
    zio.aws.cloudfront.model.GetDistributionConfigResponse.ReadOnly
  ]
  def updateVpcOrigin(
      request: UpdateVpcOriginRequest
  ): IO[AwsError, zio.aws.cloudfront.model.UpdateVpcOriginResponse.ReadOnly]
  def listDistributionsByVpcOriginId(
      request: ListDistributionsByVpcOriginIdRequest
  ): IO[AwsError, ReadOnly]
  def listKeyValueStores(
      request: ListKeyValueStoresRequest
  ): IO[AwsError, zio.aws.cloudfront.model.ListKeyValueStoresResponse.ReadOnly]
  def createPublicKey(
      request: CreatePublicKeyRequest
  ): IO[AwsError, zio.aws.cloudfront.model.CreatePublicKeyResponse.ReadOnly]
  def updateKeyGroup(
      request: UpdateKeyGroupRequest
  ): IO[AwsError, zio.aws.cloudfront.model.UpdateKeyGroupResponse.ReadOnly]
  def updateOriginRequestPolicy(request: UpdateOriginRequestPolicyRequest): IO[
    AwsError,
    zio.aws.cloudfront.model.UpdateOriginRequestPolicyResponse.ReadOnly
  ]
  def createCloudFrontOriginAccessIdentity(
      request: CreateCloudFrontOriginAccessIdentityRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse.ReadOnly
  ]
  def associateAlias(request: AssociateAliasRequest): IO[AwsError, Unit]
  def createKeyValueStore(
      request: CreateKeyValueStoreRequest
  ): IO[AwsError, zio.aws.cloudfront.model.CreateKeyValueStoreResponse.ReadOnly]
  def updatePublicKey(
      request: UpdatePublicKeyRequest
  ): IO[AwsError, zio.aws.cloudfront.model.UpdatePublicKeyResponse.ReadOnly]
  def listDistributionsByCachePolicyId(
      request: ListDistributionsByCachePolicyIdRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.ListDistributionsByCachePolicyIdResponse.ReadOnly
  ]
  def getCloudFrontOriginAccessIdentityConfig(
      request: GetCloudFrontOriginAccessIdentityConfigRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse.ReadOnly
  ]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.cloudfront.model.ListTagsForResourceResponse.ReadOnly]
  def getCachePolicyConfig(request: GetCachePolicyConfigRequest): IO[
    AwsError,
    zio.aws.cloudfront.model.GetCachePolicyConfigResponse.ReadOnly
  ]
  def listKeyGroups(
      request: ListKeyGroupsRequest
  ): IO[AwsError, zio.aws.cloudfront.model.ListKeyGroupsResponse.ReadOnly]
  def getFieldLevelEncryption(request: GetFieldLevelEncryptionRequest): IO[
    AwsError,
    zio.aws.cloudfront.model.GetFieldLevelEncryptionResponse.ReadOnly
  ]
  def listVpcOrigins(
      request: ListVpcOriginsRequest
  ): IO[AwsError, zio.aws.cloudfront.model.ListVpcOriginsResponse.ReadOnly]
  def publishFunction(
      request: PublishFunctionRequest
  ): IO[AwsError, zio.aws.cloudfront.model.PublishFunctionResponse.ReadOnly]
  def createOriginRequestPolicy(request: CreateOriginRequestPolicyRequest): IO[
    AwsError,
    zio.aws.cloudfront.model.CreateOriginRequestPolicyResponse.ReadOnly
  ]
  def tagResource(request: TagResourceRequest): IO[AwsError, Unit]
  def deleteMonitoringSubscription(
      request: DeleteMonitoringSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.DeleteMonitoringSubscriptionResponse.ReadOnly
  ]
  def listAnycastIpLists(
      request: ListAnycastIpListsRequest
  ): IO[AwsError, zio.aws.cloudfront.model.ListAnycastIpListsResponse.ReadOnly]
  def getStreamingDistributionConfig(
      request: GetStreamingDistributionConfigRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.GetStreamingDistributionConfigResponse.ReadOnly
  ]
  def updateFieldLevelEncryptionProfile(
      request: UpdateFieldLevelEncryptionProfileRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse.ReadOnly
  ]
  def createFieldLevelEncryptionProfile(
      request: CreateFieldLevelEncryptionProfileRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.CreateFieldLevelEncryptionProfileResponse.ReadOnly
  ]
  def listFunctions(
      request: ListFunctionsRequest
  ): IO[AwsError, zio.aws.cloudfront.model.ListFunctionsResponse.ReadOnly]
  def createAnycastIpList(
      request: CreateAnycastIpListRequest
  ): IO[AwsError, zio.aws.cloudfront.model.CreateAnycastIpListResponse.ReadOnly]
  def deleteFieldLevelEncryptionProfile(
      request: DeleteFieldLevelEncryptionProfileRequest
  ): IO[AwsError, Unit]
  def deleteAnycastIpList(
      request: DeleteAnycastIpListRequest
  ): IO[AwsError, Unit]
  def getResponseHeadersPolicy(request: GetResponseHeadersPolicyRequest): IO[
    AwsError,
    zio.aws.cloudfront.model.GetResponseHeadersPolicyResponse.ReadOnly
  ]
  def listInvalidations(
      request: ListInvalidationsRequest
  ): IO[AwsError, zio.aws.cloudfront.model.ListInvalidationsResponse.ReadOnly]
  def createResponseHeadersPolicy(
      request: CreateResponseHeadersPolicyRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.CreateResponseHeadersPolicyResponse.ReadOnly
  ]
  def getKeyGroupConfig(
      request: GetKeyGroupConfigRequest
  ): IO[AwsError, zio.aws.cloudfront.model.GetKeyGroupConfigResponse.ReadOnly]
  def createVpcOrigin(
      request: CreateVpcOriginRequest
  ): IO[AwsError, zio.aws.cloudfront.model.CreateVpcOriginResponse.ReadOnly]
  def updateCloudFrontOriginAccessIdentity(
      request: UpdateCloudFrontOriginAccessIdentityRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse.ReadOnly
  ]
  def listDistributionsByResponseHeadersPolicyId(
      request: ListDistributionsByResponseHeadersPolicyIdRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdResponse.ReadOnly
  ]
  def updateCachePolicy(
      request: UpdateCachePolicyRequest
  ): IO[AwsError, zio.aws.cloudfront.model.UpdateCachePolicyResponse.ReadOnly]
  def createFunction(
      request: CreateFunctionRequest
  ): IO[AwsError, zio.aws.cloudfront.model.CreateFunctionResponse.ReadOnly]
  def updateContinuousDeploymentPolicy(
      request: UpdateContinuousDeploymentPolicyRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.UpdateContinuousDeploymentPolicyResponse.ReadOnly
  ]
  def getOriginAccessControlConfig(
      request: GetOriginAccessControlConfigRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.GetOriginAccessControlConfigResponse.ReadOnly
  ]
  def getCachePolicy(
      request: GetCachePolicyRequest
  ): IO[AwsError, zio.aws.cloudfront.model.GetCachePolicyResponse.ReadOnly]
  def updateKeyValueStore(
      request: UpdateKeyValueStoreRequest
  ): IO[AwsError, zio.aws.cloudfront.model.UpdateKeyValueStoreResponse.ReadOnly]
  def getDistribution(
      request: GetDistributionRequest
  ): IO[AwsError, zio.aws.cloudfront.model.GetDistributionResponse.ReadOnly]
  def getOriginRequestPolicyConfig(
      request: GetOriginRequestPolicyConfigRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.GetOriginRequestPolicyConfigResponse.ReadOnly
  ]
  def listCloudFrontOriginAccessIdentities(
      request: ListCloudFrontOriginAccessIdentitiesRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse.ReadOnly
  ]
  def updateDistribution(
      request: UpdateDistributionRequest
  ): IO[AwsError, zio.aws.cloudfront.model.UpdateDistributionResponse.ReadOnly]
  def getFunction(
      request: GetFunctionRequest
  ): IO[AwsError, zio.aws.cloudfront.model.GetFunctionResponse.ReadOnly]
  def deleteDistribution(request: DeleteDistributionRequest): IO[AwsError, Unit]
  def updateFieldLevelEncryptionConfig(
      request: UpdateFieldLevelEncryptionConfigRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse.ReadOnly
  ]
  def listDistributionsByKeyGroup(
      request: ListDistributionsByKeyGroupRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.ListDistributionsByKeyGroupResponse.ReadOnly
  ]
  def updateDistributionWithStagingConfig(
      request: UpdateDistributionWithStagingConfigRequest
  ): IO[
    AwsError,
    zio.aws.cloudfront.model.UpdateDistributionWithStagingConfigResponse.ReadOnly
  ]
  def createDistribution(
      request: CreateDistributionRequest
  ): IO[AwsError, zio.aws.cloudfront.model.CreateDistributionResponse.ReadOnly]
}
object CloudFront {
  val live: ZLayer[AwsConfig, java.lang.Throwable, CloudFront] = customized(
    identity
  )
  def customized(
      customization: CloudFrontAsyncClientBuilder => CloudFrontAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, CloudFront] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: CloudFrontAsyncClientBuilder => CloudFrontAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, CloudFront] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = CloudFrontAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[CloudFrontAsyncClient, CloudFrontAsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[CloudFrontAsyncClient, CloudFrontAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      );
    client <- ZIO.fromAutoCloseable(
      ZIO.attempt(
        customization(
          b1.region(_root_.software.amazon.awssdk.regions.Region.AWS_GLOBAL)
        ).build()
      )
    )
  ) yield new CloudFrontImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class CloudFrontImpl[R](
      override val api: CloudFrontAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends CloudFront
      with AwsServiceBase[R] {
    override val serviceName: String = "CloudFront"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): CloudFrontImpl[R1] = new CloudFrontImpl(api, newAspect, r)
    def listResponseHeadersPolicies(
        request: ListResponseHeadersPoliciesRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.ListResponseHeadersPoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.ListResponseHeadersPoliciesRequest,
      ListResponseHeadersPoliciesResponse
    ]("listResponseHeadersPolicies", api.listResponseHeadersPolicies)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.ListResponseHeadersPoliciesResponse.wrap)
      .provideEnvironment(r)
    def getInvalidation(
        request: GetInvalidationRequest
    ): IO[AwsError, zio.aws.cloudfront.model.GetInvalidationResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.GetInvalidationRequest,
        GetInvalidationResponse
      ]("getInvalidation", api.getInvalidation)(request.buildAwsValue())
        .map(zio.aws.cloudfront.model.GetInvalidationResponse.wrap)
        .provideEnvironment(r)
    def deleteKeyGroup(request: DeleteKeyGroupRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.DeleteKeyGroupRequest,
        DeleteKeyGroupResponse
      ]("deleteKeyGroup", api.deleteKeyGroup)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def updateOriginAccessControl(
        request: UpdateOriginAccessControlRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.UpdateOriginAccessControlResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.UpdateOriginAccessControlRequest,
      UpdateOriginAccessControlResponse
    ]("updateOriginAccessControl", api.updateOriginAccessControl)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.UpdateOriginAccessControlResponse.wrap)
      .provideEnvironment(r)
    def createMonitoringSubscription(
        request: CreateMonitoringSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.CreateMonitoringSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.CreateMonitoringSubscriptionRequest,
      CreateMonitoringSubscriptionResponse
    ]("createMonitoringSubscription", api.createMonitoringSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.CreateMonitoringSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def getRealtimeLogConfig(request: GetRealtimeLogConfigRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.GetRealtimeLogConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.GetRealtimeLogConfigRequest,
      GetRealtimeLogConfigResponse
    ]("getRealtimeLogConfig", api.getRealtimeLogConfig)(request.buildAwsValue())
      .map(zio.aws.cloudfront.model.GetRealtimeLogConfigResponse.wrap)
      .provideEnvironment(r)
    def createStreamingDistribution(
        request: CreateStreamingDistributionRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.CreateStreamingDistributionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionRequest,
      CreateStreamingDistributionResponse
    ]("createStreamingDistribution", api.createStreamingDistribution)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.CreateStreamingDistributionResponse.wrap)
      .provideEnvironment(r)
    def testFunction(
        request: TestFunctionRequest
    ): IO[AwsError, zio.aws.cloudfront.model.TestFunctionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.TestFunctionRequest,
        TestFunctionResponse
      ]("testFunction", api.testFunction)(request.buildAwsValue())
        .map(zio.aws.cloudfront.model.TestFunctionResponse.wrap)
        .provideEnvironment(r)
    def getFieldLevelEncryptionProfile(
        request: GetFieldLevelEncryptionProfileRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.GetFieldLevelEncryptionProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileRequest,
      GetFieldLevelEncryptionProfileResponse
    ]("getFieldLevelEncryptionProfile", api.getFieldLevelEncryptionProfile)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.GetFieldLevelEncryptionProfileResponse.wrap)
      .provideEnvironment(r)
    def getContinuousDeploymentPolicy(
        request: GetContinuousDeploymentPolicyRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.GetContinuousDeploymentPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyRequest,
      GetContinuousDeploymentPolicyResponse
    ]("getContinuousDeploymentPolicy", api.getContinuousDeploymentPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.GetContinuousDeploymentPolicyResponse.wrap)
      .provideEnvironment(r)
    def listDistributionsByWebACLId(
        request: ListDistributionsByWebAclIdRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.ListDistributionsByWebAclIdResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdRequest,
      ListDistributionsByWebAclIdResponse
    ]("listDistributionsByWebACLId", api.listDistributionsByWebACLId)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.ListDistributionsByWebAclIdResponse.wrap)
      .provideEnvironment(r)
    def deleteCloudFrontOriginAccessIdentity(
        request: DeleteCloudFrontOriginAccessIdentityRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest,
      DeleteCloudFrontOriginAccessIdentityResponse
    ](
      "deleteCloudFrontOriginAccessIdentity",
      api.deleteCloudFrontOriginAccessIdentity
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createRealtimeLogConfig(request: CreateRealtimeLogConfigRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.CreateRealtimeLogConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.CreateRealtimeLogConfigRequest,
      CreateRealtimeLogConfigResponse
    ]("createRealtimeLogConfig", api.createRealtimeLogConfig)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.CreateRealtimeLogConfigResponse.wrap)
      .provideEnvironment(r)
    def listPublicKeys(
        request: ListPublicKeysRequest
    ): IO[AwsError, zio.aws.cloudfront.model.ListPublicKeysResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.ListPublicKeysRequest,
        ListPublicKeysResponse
      ]("listPublicKeys", api.listPublicKeys)(request.buildAwsValue())
        .map(zio.aws.cloudfront.model.ListPublicKeysResponse.wrap)
        .provideEnvironment(r)
    def createOriginAccessControl(
        request: CreateOriginAccessControlRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.CreateOriginAccessControlResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.CreateOriginAccessControlRequest,
      CreateOriginAccessControlResponse
    ]("createOriginAccessControl", api.createOriginAccessControl)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.CreateOriginAccessControlResponse.wrap)
      .provideEnvironment(r)
    def getKeyGroup(
        request: GetKeyGroupRequest
    ): IO[AwsError, zio.aws.cloudfront.model.GetKeyGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.GetKeyGroupRequest,
        GetKeyGroupResponse
      ]("getKeyGroup", api.getKeyGroup)(request.buildAwsValue())
        .map(zio.aws.cloudfront.model.GetKeyGroupResponse.wrap)
        .provideEnvironment(r)
    def getOriginAccessControl(request: GetOriginAccessControlRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.GetOriginAccessControlResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlRequest,
      GetOriginAccessControlResponse
    ]("getOriginAccessControl", api.getOriginAccessControl)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.GetOriginAccessControlResponse.wrap)
      .provideEnvironment(r)
    def createStreamingDistributionWithTags(
        request: CreateStreamingDistributionWithTagsRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.CreateStreamingDistributionWithTagsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsRequest,
      CreateStreamingDistributionWithTagsResponse
    ](
      "createStreamingDistributionWithTags",
      api.createStreamingDistributionWithTags
    )(request.buildAwsValue())
      .map(
        zio.aws.cloudfront.model.CreateStreamingDistributionWithTagsResponse.wrap
      )
      .provideEnvironment(r)
    def listConflictingAliases(request: ListConflictingAliasesRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.ListConflictingAliasesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.ListConflictingAliasesRequest,
      ListConflictingAliasesResponse
    ]("listConflictingAliases", api.listConflictingAliases)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.ListConflictingAliasesResponse.wrap)
      .provideEnvironment(r)
    def listDistributionsByOriginRequestPolicyId(
        request: ListDistributionsByOriginRequestPolicyIdRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.ListDistributionsByOriginRequestPolicyIdResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.ListDistributionsByOriginRequestPolicyIdRequest,
      ListDistributionsByOriginRequestPolicyIdResponse
    ](
      "listDistributionsByOriginRequestPolicyId",
      api.listDistributionsByOriginRequestPolicyId
    )(request.buildAwsValue())
      .map(
        zio.aws.cloudfront.model.ListDistributionsByOriginRequestPolicyIdResponse.wrap
      )
      .provideEnvironment(r)
    def deleteCachePolicy(
        request: DeleteCachePolicyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.DeleteCachePolicyRequest,
      DeleteCachePolicyResponse
    ]("deleteCachePolicy", api.deleteCachePolicy)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def deleteKeyValueStore(
        request: DeleteKeyValueStoreRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.DeleteKeyValueStoreRequest,
      DeleteKeyValueStoreResponse
    ]("deleteKeyValueStore", api.deleteKeyValueStore)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createDistributionWithTags(
        request: CreateDistributionWithTagsRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.CreateDistributionWithTagsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsRequest,
      CreateDistributionWithTagsResponse
    ]("createDistributionWithTags", api.createDistributionWithTags)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.CreateDistributionWithTagsResponse.wrap)
      .provideEnvironment(r)
    def deleteVpcOrigin(
        request: DeleteVpcOriginRequest
    ): IO[AwsError, zio.aws.cloudfront.model.DeleteVpcOriginResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.DeleteVpcOriginRequest,
        DeleteVpcOriginResponse
      ]("deleteVpcOrigin", api.deleteVpcOrigin)(request.buildAwsValue())
        .map(zio.aws.cloudfront.model.DeleteVpcOriginResponse.wrap)
        .provideEnvironment(r)
    def getFieldLevelEncryptionConfig(
        request: GetFieldLevelEncryptionConfigRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.GetFieldLevelEncryptionConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigRequest,
      GetFieldLevelEncryptionConfigResponse
    ]("getFieldLevelEncryptionConfig", api.getFieldLevelEncryptionConfig)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.GetFieldLevelEncryptionConfigResponse.wrap)
      .provideEnvironment(r)
    def deleteOriginAccessControl(
        request: DeleteOriginAccessControlRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.DeleteOriginAccessControlRequest,
      DeleteOriginAccessControlResponse
    ]("deleteOriginAccessControl", api.deleteOriginAccessControl)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def copyDistribution(request: CopyDistributionRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.CopyDistributionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.CopyDistributionRequest,
      CopyDistributionResponse
    ]("copyDistribution", api.copyDistribution)(request.buildAwsValue())
      .map(zio.aws.cloudfront.model.CopyDistributionResponse.wrap)
      .provideEnvironment(r)
    def getAnycastIpList(request: GetAnycastIpListRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.GetAnycastIpListResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.GetAnycastIpListRequest,
      GetAnycastIpListResponse
    ]("getAnycastIpList", api.getAnycastIpList)(request.buildAwsValue())
      .map(zio.aws.cloudfront.model.GetAnycastIpListResponse.wrap)
      .provideEnvironment(r)
    def updateRealtimeLogConfig(request: UpdateRealtimeLogConfigRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.UpdateRealtimeLogConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigRequest,
      UpdateRealtimeLogConfigResponse
    ]("updateRealtimeLogConfig", api.updateRealtimeLogConfig)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.UpdateRealtimeLogConfigResponse.wrap)
      .provideEnvironment(r)
    def listCachePolicies(request: ListCachePoliciesRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.ListCachePoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.ListCachePoliciesRequest,
      ListCachePoliciesResponse
    ]("listCachePolicies", api.listCachePolicies)(request.buildAwsValue())
      .map(zio.aws.cloudfront.model.ListCachePoliciesResponse.wrap)
      .provideEnvironment(r)
    def createContinuousDeploymentPolicy(
        request: CreateContinuousDeploymentPolicyRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.CreateContinuousDeploymentPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.CreateContinuousDeploymentPolicyRequest,
      CreateContinuousDeploymentPolicyResponse
    ]("createContinuousDeploymentPolicy", api.createContinuousDeploymentPolicy)(
      request.buildAwsValue()
    ).map(
      zio.aws.cloudfront.model.CreateContinuousDeploymentPolicyResponse.wrap
    ).provideEnvironment(r)
    def getVpcOrigin(
        request: GetVpcOriginRequest
    ): IO[AwsError, zio.aws.cloudfront.model.GetVpcOriginResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.GetVpcOriginRequest,
        GetVpcOriginResponse
      ]("getVpcOrigin", api.getVpcOrigin)(request.buildAwsValue())
        .map(zio.aws.cloudfront.model.GetVpcOriginResponse.wrap)
        .provideEnvironment(r)
    def listFieldLevelEncryptionConfigs(
        request: ListFieldLevelEncryptionConfigsRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.ListFieldLevelEncryptionConfigsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsRequest,
      ListFieldLevelEncryptionConfigsResponse
    ]("listFieldLevelEncryptionConfigs", api.listFieldLevelEncryptionConfigs)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.ListFieldLevelEncryptionConfigsResponse.wrap)
      .provideEnvironment(r)
    def deletePublicKey(request: DeletePublicKeyRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.DeletePublicKeyRequest,
        DeletePublicKeyResponse
      ]("deletePublicKey", api.deletePublicKey)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def getContinuousDeploymentPolicyConfig(
        request: GetContinuousDeploymentPolicyConfigRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.GetContinuousDeploymentPolicyConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyConfigRequest,
      GetContinuousDeploymentPolicyConfigResponse
    ](
      "getContinuousDeploymentPolicyConfig",
      api.getContinuousDeploymentPolicyConfig
    )(request.buildAwsValue())
      .map(
        zio.aws.cloudfront.model.GetContinuousDeploymentPolicyConfigResponse.wrap
      )
      .provideEnvironment(r)
    def listOriginRequestPolicies(
        request: ListOriginRequestPoliciesRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.ListOriginRequestPoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.ListOriginRequestPoliciesRequest,
      ListOriginRequestPoliciesResponse
    ]("listOriginRequestPolicies", api.listOriginRequestPolicies)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.ListOriginRequestPoliciesResponse.wrap)
      .provideEnvironment(r)
    def listOriginAccessControls(request: ListOriginAccessControlsRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.ListOriginAccessControlsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.ListOriginAccessControlsRequest,
      ListOriginAccessControlsResponse
    ]("listOriginAccessControls", api.listOriginAccessControls)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.ListOriginAccessControlsResponse.wrap)
      .provideEnvironment(r)
    def getPublicKey(
        request: GetPublicKeyRequest
    ): IO[AwsError, zio.aws.cloudfront.model.GetPublicKeyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.GetPublicKeyRequest,
        GetPublicKeyResponse
      ]("getPublicKey", api.getPublicKey)(request.buildAwsValue())
        .map(zio.aws.cloudfront.model.GetPublicKeyResponse.wrap)
        .provideEnvironment(r)
    def getStreamingDistribution(request: GetStreamingDistributionRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.GetStreamingDistributionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionRequest,
      GetStreamingDistributionResponse
    ]("getStreamingDistribution", api.getStreamingDistribution)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.GetStreamingDistributionResponse.wrap)
      .provideEnvironment(r)
    def updateStreamingDistribution(
        request: UpdateStreamingDistributionRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.UpdateStreamingDistributionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionRequest,
      UpdateStreamingDistributionResponse
    ]("updateStreamingDistribution", api.updateStreamingDistribution)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.UpdateStreamingDistributionResponse.wrap)
      .provideEnvironment(r)
    def createCachePolicy(request: CreateCachePolicyRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.CreateCachePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.CreateCachePolicyRequest,
      CreateCachePolicyResponse
    ]("createCachePolicy", api.createCachePolicy)(request.buildAwsValue())
      .map(zio.aws.cloudfront.model.CreateCachePolicyResponse.wrap)
      .provideEnvironment(r)
    def deleteFieldLevelEncryptionConfig(
        request: DeleteFieldLevelEncryptionConfigRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigRequest,
      DeleteFieldLevelEncryptionConfigResponse
    ]("deleteFieldLevelEncryptionConfig", api.deleteFieldLevelEncryptionConfig)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getPublicKeyConfig(request: GetPublicKeyConfigRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.GetPublicKeyConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigRequest,
      GetPublicKeyConfigResponse
    ]("getPublicKeyConfig", api.getPublicKeyConfig)(request.buildAwsValue())
      .map(zio.aws.cloudfront.model.GetPublicKeyConfigResponse.wrap)
      .provideEnvironment(r)
    def describeFunction(request: DescribeFunctionRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.DescribeFunctionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.DescribeFunctionRequest,
      DescribeFunctionResponse
    ]("describeFunction", api.describeFunction)(request.buildAwsValue())
      .map(zio.aws.cloudfront.model.DescribeFunctionResponse.wrap)
      .provideEnvironment(r)
    def deleteContinuousDeploymentPolicy(
        request: DeleteContinuousDeploymentPolicyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.DeleteContinuousDeploymentPolicyRequest,
      DeleteContinuousDeploymentPolicyResponse
    ]("deleteContinuousDeploymentPolicy", api.deleteContinuousDeploymentPolicy)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateResponseHeadersPolicy(
        request: UpdateResponseHeadersPolicyRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.UpdateResponseHeadersPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.UpdateResponseHeadersPolicyRequest,
      UpdateResponseHeadersPolicyResponse
    ]("updateResponseHeadersPolicy", api.updateResponseHeadersPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.UpdateResponseHeadersPolicyResponse.wrap)
      .provideEnvironment(r)
    def listContinuousDeploymentPolicies(
        request: ListContinuousDeploymentPoliciesRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.ListContinuousDeploymentPoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.ListContinuousDeploymentPoliciesRequest,
      ListContinuousDeploymentPoliciesResponse
    ]("listContinuousDeploymentPolicies", api.listContinuousDeploymentPolicies)(
      request.buildAwsValue()
    ).map(
      zio.aws.cloudfront.model.ListContinuousDeploymentPoliciesResponse.wrap
    ).provideEnvironment(r)
    def listFieldLevelEncryptionProfiles(
        request: ListFieldLevelEncryptionProfilesRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.ListFieldLevelEncryptionProfilesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesRequest,
      ListFieldLevelEncryptionProfilesResponse
    ]("listFieldLevelEncryptionProfiles", api.listFieldLevelEncryptionProfiles)(
      request.buildAwsValue()
    ).map(
      zio.aws.cloudfront.model.ListFieldLevelEncryptionProfilesResponse.wrap
    ).provideEnvironment(r)
    def getOriginRequestPolicy(request: GetOriginRequestPolicyRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.GetOriginRequestPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyRequest,
      GetOriginRequestPolicyResponse
    ]("getOriginRequestPolicy", api.getOriginRequestPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.GetOriginRequestPolicyResponse.wrap)
      .provideEnvironment(r)
    def deleteFunction(request: DeleteFunctionRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.DeleteFunctionRequest,
        DeleteFunctionResponse
      ]("deleteFunction", api.deleteFunction)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def createFieldLevelEncryptionConfig(
        request: CreateFieldLevelEncryptionConfigRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.CreateFieldLevelEncryptionConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigRequest,
      CreateFieldLevelEncryptionConfigResponse
    ]("createFieldLevelEncryptionConfig", api.createFieldLevelEncryptionConfig)(
      request.buildAwsValue()
    ).map(
      zio.aws.cloudfront.model.CreateFieldLevelEncryptionConfigResponse.wrap
    ).provideEnvironment(r)
    def listDistributionsByAnycastIpListId(
        request: ListDistributionsByAnycastIpListIdRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.ListDistributionsByAnycastIpListIdResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.ListDistributionsByAnycastIpListIdRequest,
      ListDistributionsByAnycastIpListIdResponse
    ](
      "listDistributionsByAnycastIpListId",
      api.listDistributionsByAnycastIpListId
    )(request.buildAwsValue())
      .map(
        zio.aws.cloudfront.model.ListDistributionsByAnycastIpListIdResponse.wrap
      )
      .provideEnvironment(r)
    def getFieldLevelEncryptionProfileConfig(
        request: GetFieldLevelEncryptionProfileConfigRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigRequest,
      GetFieldLevelEncryptionProfileConfigResponse
    ](
      "getFieldLevelEncryptionProfileConfig",
      api.getFieldLevelEncryptionProfileConfig
    )(request.buildAwsValue())
      .map(
        zio.aws.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse.wrap
      )
      .provideEnvironment(r)
    def getCloudFrontOriginAccessIdentity(
        request: GetCloudFrontOriginAccessIdentityRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest,
      GetCloudFrontOriginAccessIdentityResponse
    ](
      "getCloudFrontOriginAccessIdentity",
      api.getCloudFrontOriginAccessIdentity
    )(request.buildAwsValue())
      .map(
        zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse.wrap
      )
      .provideEnvironment(r)
    def createKeyGroup(
        request: CreateKeyGroupRequest
    ): IO[AwsError, zio.aws.cloudfront.model.CreateKeyGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.CreateKeyGroupRequest,
        CreateKeyGroupResponse
      ]("createKeyGroup", api.createKeyGroup)(request.buildAwsValue())
        .map(zio.aws.cloudfront.model.CreateKeyGroupResponse.wrap)
        .provideEnvironment(r)
    def getMonitoringSubscription(
        request: GetMonitoringSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.GetMonitoringSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.GetMonitoringSubscriptionRequest,
      GetMonitoringSubscriptionResponse
    ]("getMonitoringSubscription", api.getMonitoringSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.GetMonitoringSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def listDistributions(request: ListDistributionsRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.ListDistributionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.ListDistributionsRequest,
      ListDistributionsResponse
    ]("listDistributions", api.listDistributions)(request.buildAwsValue())
      .map(zio.aws.cloudfront.model.ListDistributionsResponse.wrap)
      .provideEnvironment(r)
    def deleteStreamingDistribution(
        request: DeleteStreamingDistributionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionRequest,
      DeleteStreamingDistributionResponse
    ]("deleteStreamingDistribution", api.deleteStreamingDistribution)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listStreamingDistributions(
        request: ListStreamingDistributionsRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.ListStreamingDistributionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsRequest,
      ListStreamingDistributionsResponse
    ]("listStreamingDistributions", api.listStreamingDistributions)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.ListStreamingDistributionsResponse.wrap)
      .provideEnvironment(r)
    def describeKeyValueStore(request: DescribeKeyValueStoreRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.DescribeKeyValueStoreResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.DescribeKeyValueStoreRequest,
      DescribeKeyValueStoreResponse
    ]("describeKeyValueStore", api.describeKeyValueStore)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.DescribeKeyValueStoreResponse.wrap)
      .provideEnvironment(r)
    def listRealtimeLogConfigs(request: ListRealtimeLogConfigsRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.ListRealtimeLogConfigsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.ListRealtimeLogConfigsRequest,
      ListRealtimeLogConfigsResponse
    ]("listRealtimeLogConfigs", api.listRealtimeLogConfigs)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.ListRealtimeLogConfigsResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteOriginRequestPolicy(
        request: DeleteOriginRequestPolicyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.DeleteOriginRequestPolicyRequest,
      DeleteOriginRequestPolicyResponse
    ]("deleteOriginRequestPolicy", api.deleteOriginRequestPolicy)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteRealtimeLogConfig(
        request: DeleteRealtimeLogConfigRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.DeleteRealtimeLogConfigRequest,
      DeleteRealtimeLogConfigResponse
    ]("deleteRealtimeLogConfig", api.deleteRealtimeLogConfig)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteResponseHeadersPolicy(
        request: DeleteResponseHeadersPolicyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.DeleteResponseHeadersPolicyRequest,
      DeleteResponseHeadersPolicyResponse
    ]("deleteResponseHeadersPolicy", api.deleteResponseHeadersPolicy)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateFunction(
        request: UpdateFunctionRequest
    ): IO[AwsError, zio.aws.cloudfront.model.UpdateFunctionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.UpdateFunctionRequest,
        UpdateFunctionResponse
      ]("updateFunction", api.updateFunction)(request.buildAwsValue())
        .map(zio.aws.cloudfront.model.UpdateFunctionResponse.wrap)
        .provideEnvironment(r)
    def createInvalidation(request: CreateInvalidationRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.CreateInvalidationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.CreateInvalidationRequest,
      CreateInvalidationResponse
    ]("createInvalidation", api.createInvalidation)(request.buildAwsValue())
      .map(zio.aws.cloudfront.model.CreateInvalidationResponse.wrap)
      .provideEnvironment(r)
    def listDistributionsByRealtimeLogConfig(
        request: ListDistributionsByRealtimeLogConfigRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.ListDistributionsByRealtimeLogConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.ListDistributionsByRealtimeLogConfigRequest,
      ListDistributionsByRealtimeLogConfigResponse
    ](
      "listDistributionsByRealtimeLogConfig",
      api.listDistributionsByRealtimeLogConfig
    )(request.buildAwsValue())
      .map(
        zio.aws.cloudfront.model.ListDistributionsByRealtimeLogConfigResponse.wrap
      )
      .provideEnvironment(r)
    def getResponseHeadersPolicyConfig(
        request: GetResponseHeadersPolicyConfigRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.GetResponseHeadersPolicyConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyConfigRequest,
      GetResponseHeadersPolicyConfigResponse
    ]("getResponseHeadersPolicyConfig", api.getResponseHeadersPolicyConfig)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.GetResponseHeadersPolicyConfigResponse.wrap)
      .provideEnvironment(r)
    def getDistributionConfig(request: GetDistributionConfigRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.GetDistributionConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigRequest,
      GetDistributionConfigResponse
    ]("getDistributionConfig", api.getDistributionConfig)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.GetDistributionConfigResponse.wrap)
      .provideEnvironment(r)
    def updateVpcOrigin(
        request: UpdateVpcOriginRequest
    ): IO[AwsError, zio.aws.cloudfront.model.UpdateVpcOriginResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.UpdateVpcOriginRequest,
        UpdateVpcOriginResponse
      ]("updateVpcOrigin", api.updateVpcOrigin)(request.buildAwsValue())
        .map(zio.aws.cloudfront.model.UpdateVpcOriginResponse.wrap)
        .provideEnvironment(r)
    def listDistributionsByVpcOriginId(
        request: ListDistributionsByVpcOriginIdRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.ListDistributionsByVpcOriginIdRequest,
      ListDistributionsByVpcOriginIdResponse
    ]("listDistributionsByVpcOriginId", api.listDistributionsByVpcOriginId)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.ListDistributionsByVpcOriginIdResponse.wrap)
      .provideEnvironment(r)
    def listKeyValueStores(request: ListKeyValueStoresRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.ListKeyValueStoresResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.ListKeyValueStoresRequest,
      ListKeyValueStoresResponse
    ]("listKeyValueStores", api.listKeyValueStores)(request.buildAwsValue())
      .map(zio.aws.cloudfront.model.ListKeyValueStoresResponse.wrap)
      .provideEnvironment(r)
    def createPublicKey(
        request: CreatePublicKeyRequest
    ): IO[AwsError, zio.aws.cloudfront.model.CreatePublicKeyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyRequest,
        CreatePublicKeyResponse
      ]("createPublicKey", api.createPublicKey)(request.buildAwsValue())
        .map(zio.aws.cloudfront.model.CreatePublicKeyResponse.wrap)
        .provideEnvironment(r)
    def updateKeyGroup(
        request: UpdateKeyGroupRequest
    ): IO[AwsError, zio.aws.cloudfront.model.UpdateKeyGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.UpdateKeyGroupRequest,
        UpdateKeyGroupResponse
      ]("updateKeyGroup", api.updateKeyGroup)(request.buildAwsValue())
        .map(zio.aws.cloudfront.model.UpdateKeyGroupResponse.wrap)
        .provideEnvironment(r)
    def updateOriginRequestPolicy(
        request: UpdateOriginRequestPolicyRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.UpdateOriginRequestPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyRequest,
      UpdateOriginRequestPolicyResponse
    ]("updateOriginRequestPolicy", api.updateOriginRequestPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.UpdateOriginRequestPolicyResponse.wrap)
      .provideEnvironment(r)
    def createCloudFrontOriginAccessIdentity(
        request: CreateCloudFrontOriginAccessIdentityRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest,
      CreateCloudFrontOriginAccessIdentityResponse
    ](
      "createCloudFrontOriginAccessIdentity",
      api.createCloudFrontOriginAccessIdentity
    )(request.buildAwsValue())
      .map(
        zio.aws.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse.wrap
      )
      .provideEnvironment(r)
    def associateAlias(request: AssociateAliasRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.AssociateAliasRequest,
        AssociateAliasResponse
      ]("associateAlias", api.associateAlias)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def createKeyValueStore(request: CreateKeyValueStoreRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.CreateKeyValueStoreResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.CreateKeyValueStoreRequest,
      CreateKeyValueStoreResponse
    ]("createKeyValueStore", api.createKeyValueStore)(request.buildAwsValue())
      .map(zio.aws.cloudfront.model.CreateKeyValueStoreResponse.wrap)
      .provideEnvironment(r)
    def updatePublicKey(
        request: UpdatePublicKeyRequest
    ): IO[AwsError, zio.aws.cloudfront.model.UpdatePublicKeyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyRequest,
        UpdatePublicKeyResponse
      ]("updatePublicKey", api.updatePublicKey)(request.buildAwsValue())
        .map(zio.aws.cloudfront.model.UpdatePublicKeyResponse.wrap)
        .provideEnvironment(r)
    def listDistributionsByCachePolicyId(
        request: ListDistributionsByCachePolicyIdRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.ListDistributionsByCachePolicyIdResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.ListDistributionsByCachePolicyIdRequest,
      ListDistributionsByCachePolicyIdResponse
    ]("listDistributionsByCachePolicyId", api.listDistributionsByCachePolicyId)(
      request.buildAwsValue()
    ).map(
      zio.aws.cloudfront.model.ListDistributionsByCachePolicyIdResponse.wrap
    ).provideEnvironment(r)
    def getCloudFrontOriginAccessIdentityConfig(
        request: GetCloudFrontOriginAccessIdentityConfigRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest,
      GetCloudFrontOriginAccessIdentityConfigResponse
    ](
      "getCloudFrontOriginAccessIdentityConfig",
      api.getCloudFrontOriginAccessIdentityConfig
    )(request.buildAwsValue())
      .map(
        zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse.wrap
      )
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.cloudfront.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def getCachePolicyConfig(request: GetCachePolicyConfigRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.GetCachePolicyConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.GetCachePolicyConfigRequest,
      GetCachePolicyConfigResponse
    ]("getCachePolicyConfig", api.getCachePolicyConfig)(request.buildAwsValue())
      .map(zio.aws.cloudfront.model.GetCachePolicyConfigResponse.wrap)
      .provideEnvironment(r)
    def listKeyGroups(
        request: ListKeyGroupsRequest
    ): IO[AwsError, zio.aws.cloudfront.model.ListKeyGroupsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsRequest,
        ListKeyGroupsResponse
      ]("listKeyGroups", api.listKeyGroups)(request.buildAwsValue())
        .map(zio.aws.cloudfront.model.ListKeyGroupsResponse.wrap)
        .provideEnvironment(r)
    def getFieldLevelEncryption(request: GetFieldLevelEncryptionRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.GetFieldLevelEncryptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionRequest,
      GetFieldLevelEncryptionResponse
    ]("getFieldLevelEncryption", api.getFieldLevelEncryption)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.GetFieldLevelEncryptionResponse.wrap)
      .provideEnvironment(r)
    def listVpcOrigins(
        request: ListVpcOriginsRequest
    ): IO[AwsError, zio.aws.cloudfront.model.ListVpcOriginsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.ListVpcOriginsRequest,
        ListVpcOriginsResponse
      ]("listVpcOrigins", api.listVpcOrigins)(request.buildAwsValue())
        .map(zio.aws.cloudfront.model.ListVpcOriginsResponse.wrap)
        .provideEnvironment(r)
    def publishFunction(
        request: PublishFunctionRequest
    ): IO[AwsError, zio.aws.cloudfront.model.PublishFunctionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.PublishFunctionRequest,
        PublishFunctionResponse
      ]("publishFunction", api.publishFunction)(request.buildAwsValue())
        .map(zio.aws.cloudfront.model.PublishFunctionResponse.wrap)
        .provideEnvironment(r)
    def createOriginRequestPolicy(
        request: CreateOriginRequestPolicyRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.CreateOriginRequestPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyRequest,
      CreateOriginRequestPolicyResponse
    ]("createOriginRequestPolicy", api.createOriginRequestPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.CreateOriginRequestPolicyResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteMonitoringSubscription(
        request: DeleteMonitoringSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.DeleteMonitoringSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.DeleteMonitoringSubscriptionRequest,
      DeleteMonitoringSubscriptionResponse
    ]("deleteMonitoringSubscription", api.deleteMonitoringSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.DeleteMonitoringSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def listAnycastIpLists(request: ListAnycastIpListsRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.ListAnycastIpListsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.ListAnycastIpListsRequest,
      ListAnycastIpListsResponse
    ]("listAnycastIpLists", api.listAnycastIpLists)(request.buildAwsValue())
      .map(zio.aws.cloudfront.model.ListAnycastIpListsResponse.wrap)
      .provideEnvironment(r)
    def getStreamingDistributionConfig(
        request: GetStreamingDistributionConfigRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.GetStreamingDistributionConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigRequest,
      GetStreamingDistributionConfigResponse
    ]("getStreamingDistributionConfig", api.getStreamingDistributionConfig)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.GetStreamingDistributionConfigResponse.wrap)
      .provideEnvironment(r)
    def updateFieldLevelEncryptionProfile(
        request: UpdateFieldLevelEncryptionProfileRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileRequest,
      UpdateFieldLevelEncryptionProfileResponse
    ](
      "updateFieldLevelEncryptionProfile",
      api.updateFieldLevelEncryptionProfile
    )(request.buildAwsValue())
      .map(
        zio.aws.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse.wrap
      )
      .provideEnvironment(r)
    def createFieldLevelEncryptionProfile(
        request: CreateFieldLevelEncryptionProfileRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.CreateFieldLevelEncryptionProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileRequest,
      CreateFieldLevelEncryptionProfileResponse
    ](
      "createFieldLevelEncryptionProfile",
      api.createFieldLevelEncryptionProfile
    )(request.buildAwsValue())
      .map(
        zio.aws.cloudfront.model.CreateFieldLevelEncryptionProfileResponse.wrap
      )
      .provideEnvironment(r)
    def listFunctions(
        request: ListFunctionsRequest
    ): IO[AwsError, zio.aws.cloudfront.model.ListFunctionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.ListFunctionsRequest,
        ListFunctionsResponse
      ]("listFunctions", api.listFunctions)(request.buildAwsValue())
        .map(zio.aws.cloudfront.model.ListFunctionsResponse.wrap)
        .provideEnvironment(r)
    def createAnycastIpList(request: CreateAnycastIpListRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.CreateAnycastIpListResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.CreateAnycastIpListRequest,
      CreateAnycastIpListResponse
    ]("createAnycastIpList", api.createAnycastIpList)(request.buildAwsValue())
      .map(zio.aws.cloudfront.model.CreateAnycastIpListResponse.wrap)
      .provideEnvironment(r)
    def deleteFieldLevelEncryptionProfile(
        request: DeleteFieldLevelEncryptionProfileRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileRequest,
      DeleteFieldLevelEncryptionProfileResponse
    ](
      "deleteFieldLevelEncryptionProfile",
      api.deleteFieldLevelEncryptionProfile
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteAnycastIpList(
        request: DeleteAnycastIpListRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.DeleteAnycastIpListRequest,
      DeleteAnycastIpListResponse
    ]("deleteAnycastIpList", api.deleteAnycastIpList)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getResponseHeadersPolicy(request: GetResponseHeadersPolicyRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.GetResponseHeadersPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyRequest,
      GetResponseHeadersPolicyResponse
    ]("getResponseHeadersPolicy", api.getResponseHeadersPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.GetResponseHeadersPolicyResponse.wrap)
      .provideEnvironment(r)
    def listInvalidations(request: ListInvalidationsRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.ListInvalidationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.ListInvalidationsRequest,
      ListInvalidationsResponse
    ]("listInvalidations", api.listInvalidations)(request.buildAwsValue())
      .map(zio.aws.cloudfront.model.ListInvalidationsResponse.wrap)
      .provideEnvironment(r)
    def createResponseHeadersPolicy(
        request: CreateResponseHeadersPolicyRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.CreateResponseHeadersPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.CreateResponseHeadersPolicyRequest,
      CreateResponseHeadersPolicyResponse
    ]("createResponseHeadersPolicy", api.createResponseHeadersPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.CreateResponseHeadersPolicyResponse.wrap)
      .provideEnvironment(r)
    def getKeyGroupConfig(request: GetKeyGroupConfigRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.GetKeyGroupConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.GetKeyGroupConfigRequest,
      GetKeyGroupConfigResponse
    ]("getKeyGroupConfig", api.getKeyGroupConfig)(request.buildAwsValue())
      .map(zio.aws.cloudfront.model.GetKeyGroupConfigResponse.wrap)
      .provideEnvironment(r)
    def createVpcOrigin(
        request: CreateVpcOriginRequest
    ): IO[AwsError, zio.aws.cloudfront.model.CreateVpcOriginResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.CreateVpcOriginRequest,
        CreateVpcOriginResponse
      ]("createVpcOrigin", api.createVpcOrigin)(request.buildAwsValue())
        .map(zio.aws.cloudfront.model.CreateVpcOriginResponse.wrap)
        .provideEnvironment(r)
    def updateCloudFrontOriginAccessIdentity(
        request: UpdateCloudFrontOriginAccessIdentityRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest,
      UpdateCloudFrontOriginAccessIdentityResponse
    ](
      "updateCloudFrontOriginAccessIdentity",
      api.updateCloudFrontOriginAccessIdentity
    )(request.buildAwsValue())
      .map(
        zio.aws.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse.wrap
      )
      .provideEnvironment(r)
    def listDistributionsByResponseHeadersPolicyId(
        request: ListDistributionsByResponseHeadersPolicyIdRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdRequest,
      ListDistributionsByResponseHeadersPolicyIdResponse
    ](
      "listDistributionsByResponseHeadersPolicyId",
      api.listDistributionsByResponseHeadersPolicyId
    )(request.buildAwsValue())
      .map(
        zio.aws.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdResponse.wrap
      )
      .provideEnvironment(r)
    def updateCachePolicy(request: UpdateCachePolicyRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.UpdateCachePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.UpdateCachePolicyRequest,
      UpdateCachePolicyResponse
    ]("updateCachePolicy", api.updateCachePolicy)(request.buildAwsValue())
      .map(zio.aws.cloudfront.model.UpdateCachePolicyResponse.wrap)
      .provideEnvironment(r)
    def createFunction(
        request: CreateFunctionRequest
    ): IO[AwsError, zio.aws.cloudfront.model.CreateFunctionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.CreateFunctionRequest,
        CreateFunctionResponse
      ]("createFunction", api.createFunction)(request.buildAwsValue())
        .map(zio.aws.cloudfront.model.CreateFunctionResponse.wrap)
        .provideEnvironment(r)
    def updateContinuousDeploymentPolicy(
        request: UpdateContinuousDeploymentPolicyRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.UpdateContinuousDeploymentPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.UpdateContinuousDeploymentPolicyRequest,
      UpdateContinuousDeploymentPolicyResponse
    ]("updateContinuousDeploymentPolicy", api.updateContinuousDeploymentPolicy)(
      request.buildAwsValue()
    ).map(
      zio.aws.cloudfront.model.UpdateContinuousDeploymentPolicyResponse.wrap
    ).provideEnvironment(r)
    def getOriginAccessControlConfig(
        request: GetOriginAccessControlConfigRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.GetOriginAccessControlConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlConfigRequest,
      GetOriginAccessControlConfigResponse
    ]("getOriginAccessControlConfig", api.getOriginAccessControlConfig)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.GetOriginAccessControlConfigResponse.wrap)
      .provideEnvironment(r)
    def getCachePolicy(
        request: GetCachePolicyRequest
    ): IO[AwsError, zio.aws.cloudfront.model.GetCachePolicyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.GetCachePolicyRequest,
        GetCachePolicyResponse
      ]("getCachePolicy", api.getCachePolicy)(request.buildAwsValue())
        .map(zio.aws.cloudfront.model.GetCachePolicyResponse.wrap)
        .provideEnvironment(r)
    def updateKeyValueStore(request: UpdateKeyValueStoreRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.UpdateKeyValueStoreResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.UpdateKeyValueStoreRequest,
      UpdateKeyValueStoreResponse
    ]("updateKeyValueStore", api.updateKeyValueStore)(request.buildAwsValue())
      .map(zio.aws.cloudfront.model.UpdateKeyValueStoreResponse.wrap)
      .provideEnvironment(r)
    def getDistribution(
        request: GetDistributionRequest
    ): IO[AwsError, zio.aws.cloudfront.model.GetDistributionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.GetDistributionRequest,
        GetDistributionResponse
      ]("getDistribution", api.getDistribution)(request.buildAwsValue())
        .map(zio.aws.cloudfront.model.GetDistributionResponse.wrap)
        .provideEnvironment(r)
    def getOriginRequestPolicyConfig(
        request: GetOriginRequestPolicyConfigRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.GetOriginRequestPolicyConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyConfigRequest,
      GetOriginRequestPolicyConfigResponse
    ]("getOriginRequestPolicyConfig", api.getOriginRequestPolicyConfig)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.GetOriginRequestPolicyConfigResponse.wrap)
      .provideEnvironment(r)
    def listCloudFrontOriginAccessIdentities(
        request: ListCloudFrontOriginAccessIdentitiesRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest,
      ListCloudFrontOriginAccessIdentitiesResponse
    ](
      "listCloudFrontOriginAccessIdentities",
      api.listCloudFrontOriginAccessIdentities
    )(request.buildAwsValue())
      .map(
        zio.aws.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse.wrap
      )
      .provideEnvironment(r)
    def updateDistribution(request: UpdateDistributionRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.UpdateDistributionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.UpdateDistributionRequest,
      UpdateDistributionResponse
    ]("updateDistribution", api.updateDistribution)(request.buildAwsValue())
      .map(zio.aws.cloudfront.model.UpdateDistributionResponse.wrap)
      .provideEnvironment(r)
    def getFunction(
        request: GetFunctionRequest
    ): IO[AwsError, zio.aws.cloudfront.model.GetFunctionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudfront.model.GetFunctionRequest,
        GetFunctionResponse
      ]("getFunction", api.getFunction)(request.buildAwsValue())
        .map(zio.aws.cloudfront.model.GetFunctionResponse.wrap)
        .provideEnvironment(r)
    def deleteDistribution(
        request: DeleteDistributionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.DeleteDistributionRequest,
      DeleteDistributionResponse
    ]("deleteDistribution", api.deleteDistribution)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateFieldLevelEncryptionConfig(
        request: UpdateFieldLevelEncryptionConfigRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigRequest,
      UpdateFieldLevelEncryptionConfigResponse
    ]("updateFieldLevelEncryptionConfig", api.updateFieldLevelEncryptionConfig)(
      request.buildAwsValue()
    ).map(
      zio.aws.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse.wrap
    ).provideEnvironment(r)
    def listDistributionsByKeyGroup(
        request: ListDistributionsByKeyGroupRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.ListDistributionsByKeyGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.ListDistributionsByKeyGroupRequest,
      ListDistributionsByKeyGroupResponse
    ]("listDistributionsByKeyGroup", api.listDistributionsByKeyGroup)(
      request.buildAwsValue()
    ).map(zio.aws.cloudfront.model.ListDistributionsByKeyGroupResponse.wrap)
      .provideEnvironment(r)
    def updateDistributionWithStagingConfig(
        request: UpdateDistributionWithStagingConfigRequest
    ): IO[
      AwsError,
      zio.aws.cloudfront.model.UpdateDistributionWithStagingConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.UpdateDistributionWithStagingConfigRequest,
      UpdateDistributionWithStagingConfigResponse
    ](
      "updateDistributionWithStagingConfig",
      api.updateDistributionWithStagingConfig
    )(request.buildAwsValue())
      .map(
        zio.aws.cloudfront.model.UpdateDistributionWithStagingConfigResponse.wrap
      )
      .provideEnvironment(r)
    def createDistribution(request: CreateDistributionRequest): IO[
      AwsError,
      zio.aws.cloudfront.model.CreateDistributionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudfront.model.CreateDistributionRequest,
      CreateDistributionResponse
    ]("createDistribution", api.createDistribution)(request.buildAwsValue())
      .map(zio.aws.cloudfront.model.CreateDistributionResponse.wrap)
      .provideEnvironment(r)
  }
  def listResponseHeadersPolicies(
      request: ListResponseHeadersPoliciesRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListResponseHeadersPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listResponseHeadersPolicies(request))
  def getInvalidation(request: GetInvalidationRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetInvalidationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInvalidation(request))
  def deleteKeyGroup(
      request: DeleteKeyGroupRequest
  ): ZIO[zio.aws.cloudfront.CloudFront, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteKeyGroup(request))
  def updateOriginAccessControl(request: UpdateOriginAccessControlRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.UpdateOriginAccessControlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateOriginAccessControl(request))
  def createMonitoringSubscription(
      request: CreateMonitoringSubscriptionRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.CreateMonitoringSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMonitoringSubscription(request))
  def getRealtimeLogConfig(request: GetRealtimeLogConfigRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetRealtimeLogConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRealtimeLogConfig(request))
  def createStreamingDistribution(
      request: CreateStreamingDistributionRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.CreateStreamingDistributionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStreamingDistribution(request))
  def testFunction(request: TestFunctionRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.TestFunctionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.testFunction(request))
  def getFieldLevelEncryptionProfile(
      request: GetFieldLevelEncryptionProfileRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetFieldLevelEncryptionProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFieldLevelEncryptionProfile(request))
  def getContinuousDeploymentPolicy(
      request: GetContinuousDeploymentPolicyRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetContinuousDeploymentPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContinuousDeploymentPolicy(request))
  def listDistributionsByWebACLId(
      request: ListDistributionsByWebAclIdRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListDistributionsByWebAclIdResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDistributionsByWebACLId(request))
  def deleteCloudFrontOriginAccessIdentity(
      request: DeleteCloudFrontOriginAccessIdentityRequest
  ): ZIO[zio.aws.cloudfront.CloudFront, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteCloudFrontOriginAccessIdentity(request))
  def createRealtimeLogConfig(request: CreateRealtimeLogConfigRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.CreateRealtimeLogConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRealtimeLogConfig(request))
  def listPublicKeys(request: ListPublicKeysRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListPublicKeysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPublicKeys(request))
  def createOriginAccessControl(request: CreateOriginAccessControlRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.CreateOriginAccessControlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createOriginAccessControl(request))
  def getKeyGroup(request: GetKeyGroupRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetKeyGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getKeyGroup(request))
  def getOriginAccessControl(request: GetOriginAccessControlRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetOriginAccessControlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getOriginAccessControl(request))
  def createStreamingDistributionWithTags(
      request: CreateStreamingDistributionWithTagsRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.CreateStreamingDistributionWithTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStreamingDistributionWithTags(request))
  def listConflictingAliases(request: ListConflictingAliasesRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListConflictingAliasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listConflictingAliases(request))
  def listDistributionsByOriginRequestPolicyId(
      request: ListDistributionsByOriginRequestPolicyIdRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListDistributionsByOriginRequestPolicyIdResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDistributionsByOriginRequestPolicyId(request))
  def deleteCachePolicy(
      request: DeleteCachePolicyRequest
  ): ZIO[zio.aws.cloudfront.CloudFront, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteCachePolicy(request))
  def deleteKeyValueStore(
      request: DeleteKeyValueStoreRequest
  ): ZIO[zio.aws.cloudfront.CloudFront, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteKeyValueStore(request))
  def createDistributionWithTags(
      request: CreateDistributionWithTagsRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.CreateDistributionWithTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDistributionWithTags(request))
  def deleteVpcOrigin(request: DeleteVpcOriginRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.DeleteVpcOriginResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVpcOrigin(request))
  def getFieldLevelEncryptionConfig(
      request: GetFieldLevelEncryptionConfigRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetFieldLevelEncryptionConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFieldLevelEncryptionConfig(request))
  def deleteOriginAccessControl(
      request: DeleteOriginAccessControlRequest
  ): ZIO[zio.aws.cloudfront.CloudFront, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteOriginAccessControl(request))
  def copyDistribution(request: CopyDistributionRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.CopyDistributionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copyDistribution(request))
  def getAnycastIpList(request: GetAnycastIpListRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetAnycastIpListResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAnycastIpList(request))
  def updateRealtimeLogConfig(request: UpdateRealtimeLogConfigRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.UpdateRealtimeLogConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRealtimeLogConfig(request))
  def listCachePolicies(request: ListCachePoliciesRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListCachePoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCachePolicies(request))
  def createContinuousDeploymentPolicy(
      request: CreateContinuousDeploymentPolicyRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.CreateContinuousDeploymentPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createContinuousDeploymentPolicy(request))
  def getVpcOrigin(request: GetVpcOriginRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetVpcOriginResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVpcOrigin(request))
  def listFieldLevelEncryptionConfigs(
      request: ListFieldLevelEncryptionConfigsRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListFieldLevelEncryptionConfigsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFieldLevelEncryptionConfigs(request))
  def deletePublicKey(
      request: DeletePublicKeyRequest
  ): ZIO[zio.aws.cloudfront.CloudFront, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deletePublicKey(request))
  def getContinuousDeploymentPolicyConfig(
      request: GetContinuousDeploymentPolicyConfigRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetContinuousDeploymentPolicyConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContinuousDeploymentPolicyConfig(request))
  def listOriginRequestPolicies(request: ListOriginRequestPoliciesRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListOriginRequestPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOriginRequestPolicies(request))
  def listOriginAccessControls(request: ListOriginAccessControlsRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListOriginAccessControlsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOriginAccessControls(request))
  def getPublicKey(request: GetPublicKeyRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetPublicKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPublicKey(request))
  def getStreamingDistribution(request: GetStreamingDistributionRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetStreamingDistributionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStreamingDistribution(request))
  def updateStreamingDistribution(
      request: UpdateStreamingDistributionRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.UpdateStreamingDistributionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateStreamingDistribution(request))
  def createCachePolicy(request: CreateCachePolicyRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.CreateCachePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCachePolicy(request))
  def deleteFieldLevelEncryptionConfig(
      request: DeleteFieldLevelEncryptionConfigRequest
  ): ZIO[zio.aws.cloudfront.CloudFront, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteFieldLevelEncryptionConfig(request))
  def getPublicKeyConfig(request: GetPublicKeyConfigRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetPublicKeyConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPublicKeyConfig(request))
  def describeFunction(request: DescribeFunctionRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.DescribeFunctionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFunction(request))
  def deleteContinuousDeploymentPolicy(
      request: DeleteContinuousDeploymentPolicyRequest
  ): ZIO[zio.aws.cloudfront.CloudFront, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteContinuousDeploymentPolicy(request))
  def updateResponseHeadersPolicy(
      request: UpdateResponseHeadersPolicyRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.UpdateResponseHeadersPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateResponseHeadersPolicy(request))
  def listContinuousDeploymentPolicies(
      request: ListContinuousDeploymentPoliciesRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListContinuousDeploymentPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listContinuousDeploymentPolicies(request))
  def listFieldLevelEncryptionProfiles(
      request: ListFieldLevelEncryptionProfilesRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListFieldLevelEncryptionProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFieldLevelEncryptionProfiles(request))
  def getOriginRequestPolicy(request: GetOriginRequestPolicyRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetOriginRequestPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getOriginRequestPolicy(request))
  def deleteFunction(
      request: DeleteFunctionRequest
  ): ZIO[zio.aws.cloudfront.CloudFront, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteFunction(request))
  def createFieldLevelEncryptionConfig(
      request: CreateFieldLevelEncryptionConfigRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.CreateFieldLevelEncryptionConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFieldLevelEncryptionConfig(request))
  def listDistributionsByAnycastIpListId(
      request: ListDistributionsByAnycastIpListIdRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListDistributionsByAnycastIpListIdResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDistributionsByAnycastIpListId(request))
  def getFieldLevelEncryptionProfileConfig(
      request: GetFieldLevelEncryptionProfileConfigRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFieldLevelEncryptionProfileConfig(request))
  def getCloudFrontOriginAccessIdentity(
      request: GetCloudFrontOriginAccessIdentityRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCloudFrontOriginAccessIdentity(request))
  def createKeyGroup(request: CreateKeyGroupRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.CreateKeyGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createKeyGroup(request))
  def getMonitoringSubscription(request: GetMonitoringSubscriptionRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetMonitoringSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMonitoringSubscription(request))
  def listDistributions(request: ListDistributionsRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListDistributionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDistributions(request))
  def deleteStreamingDistribution(
      request: DeleteStreamingDistributionRequest
  ): ZIO[zio.aws.cloudfront.CloudFront, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteStreamingDistribution(request))
  def listStreamingDistributions(
      request: ListStreamingDistributionsRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListStreamingDistributionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStreamingDistributions(request))
  def describeKeyValueStore(request: DescribeKeyValueStoreRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.DescribeKeyValueStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeKeyValueStore(request))
  def listRealtimeLogConfigs(request: ListRealtimeLogConfigsRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListRealtimeLogConfigsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRealtimeLogConfigs(request))
  def untagResource(
      request: UntagResourceRequest
  ): ZIO[zio.aws.cloudfront.CloudFront, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def deleteOriginRequestPolicy(
      request: DeleteOriginRequestPolicyRequest
  ): ZIO[zio.aws.cloudfront.CloudFront, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteOriginRequestPolicy(request))
  def deleteRealtimeLogConfig(
      request: DeleteRealtimeLogConfigRequest
  ): ZIO[zio.aws.cloudfront.CloudFront, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteRealtimeLogConfig(request))
  def deleteResponseHeadersPolicy(
      request: DeleteResponseHeadersPolicyRequest
  ): ZIO[zio.aws.cloudfront.CloudFront, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteResponseHeadersPolicy(request))
  def updateFunction(request: UpdateFunctionRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.UpdateFunctionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFunction(request))
  def createInvalidation(request: CreateInvalidationRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.CreateInvalidationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createInvalidation(request))
  def listDistributionsByRealtimeLogConfig(
      request: ListDistributionsByRealtimeLogConfigRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListDistributionsByRealtimeLogConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDistributionsByRealtimeLogConfig(request))
  def getResponseHeadersPolicyConfig(
      request: GetResponseHeadersPolicyConfigRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetResponseHeadersPolicyConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResponseHeadersPolicyConfig(request))
  def getDistributionConfig(request: GetDistributionConfigRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetDistributionConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDistributionConfig(request))
  def updateVpcOrigin(request: UpdateVpcOriginRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.UpdateVpcOriginResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVpcOrigin(request))
  def listDistributionsByVpcOriginId(
      request: ListDistributionsByVpcOriginIdRequest
  ): ZIO[zio.aws.cloudfront.CloudFront, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listDistributionsByVpcOriginId(request))
  def listKeyValueStores(request: ListKeyValueStoresRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListKeyValueStoresResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listKeyValueStores(request))
  def createPublicKey(request: CreatePublicKeyRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.CreatePublicKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPublicKey(request))
  def updateKeyGroup(request: UpdateKeyGroupRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.UpdateKeyGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateKeyGroup(request))
  def updateOriginRequestPolicy(request: UpdateOriginRequestPolicyRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.UpdateOriginRequestPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateOriginRequestPolicy(request))
  def createCloudFrontOriginAccessIdentity(
      request: CreateCloudFrontOriginAccessIdentityRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCloudFrontOriginAccessIdentity(request))
  def associateAlias(
      request: AssociateAliasRequest
  ): ZIO[zio.aws.cloudfront.CloudFront, AwsError, Unit] =
    ZIO.serviceWithZIO(_.associateAlias(request))
  def createKeyValueStore(request: CreateKeyValueStoreRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.CreateKeyValueStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createKeyValueStore(request))
  def updatePublicKey(request: UpdatePublicKeyRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.UpdatePublicKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePublicKey(request))
  def listDistributionsByCachePolicyId(
      request: ListDistributionsByCachePolicyIdRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListDistributionsByCachePolicyIdResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDistributionsByCachePolicyId(request))
  def getCloudFrontOriginAccessIdentityConfig(
      request: GetCloudFrontOriginAccessIdentityConfigRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCloudFrontOriginAccessIdentityConfig(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def getCachePolicyConfig(request: GetCachePolicyConfigRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetCachePolicyConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCachePolicyConfig(request))
  def listKeyGroups(request: ListKeyGroupsRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListKeyGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listKeyGroups(request))
  def getFieldLevelEncryption(request: GetFieldLevelEncryptionRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetFieldLevelEncryptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFieldLevelEncryption(request))
  def listVpcOrigins(request: ListVpcOriginsRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListVpcOriginsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVpcOrigins(request))
  def publishFunction(request: PublishFunctionRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.PublishFunctionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.publishFunction(request))
  def createOriginRequestPolicy(request: CreateOriginRequestPolicyRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.CreateOriginRequestPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createOriginRequestPolicy(request))
  def tagResource(
      request: TagResourceRequest
  ): ZIO[zio.aws.cloudfront.CloudFront, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def deleteMonitoringSubscription(
      request: DeleteMonitoringSubscriptionRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.DeleteMonitoringSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMonitoringSubscription(request))
  def listAnycastIpLists(request: ListAnycastIpListsRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListAnycastIpListsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAnycastIpLists(request))
  def getStreamingDistributionConfig(
      request: GetStreamingDistributionConfigRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetStreamingDistributionConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStreamingDistributionConfig(request))
  def updateFieldLevelEncryptionProfile(
      request: UpdateFieldLevelEncryptionProfileRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFieldLevelEncryptionProfile(request))
  def createFieldLevelEncryptionProfile(
      request: CreateFieldLevelEncryptionProfileRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.CreateFieldLevelEncryptionProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFieldLevelEncryptionProfile(request))
  def listFunctions(request: ListFunctionsRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListFunctionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFunctions(request))
  def createAnycastIpList(request: CreateAnycastIpListRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.CreateAnycastIpListResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAnycastIpList(request))
  def deleteFieldLevelEncryptionProfile(
      request: DeleteFieldLevelEncryptionProfileRequest
  ): ZIO[zio.aws.cloudfront.CloudFront, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteFieldLevelEncryptionProfile(request))
  def deleteAnycastIpList(
      request: DeleteAnycastIpListRequest
  ): ZIO[zio.aws.cloudfront.CloudFront, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAnycastIpList(request))
  def getResponseHeadersPolicy(request: GetResponseHeadersPolicyRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetResponseHeadersPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResponseHeadersPolicy(request))
  def listInvalidations(request: ListInvalidationsRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListInvalidationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInvalidations(request))
  def createResponseHeadersPolicy(
      request: CreateResponseHeadersPolicyRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.CreateResponseHeadersPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createResponseHeadersPolicy(request))
  def getKeyGroupConfig(request: GetKeyGroupConfigRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetKeyGroupConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getKeyGroupConfig(request))
  def createVpcOrigin(request: CreateVpcOriginRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.CreateVpcOriginResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVpcOrigin(request))
  def updateCloudFrontOriginAccessIdentity(
      request: UpdateCloudFrontOriginAccessIdentityRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateCloudFrontOriginAccessIdentity(request))
  def listDistributionsByResponseHeadersPolicyId(
      request: ListDistributionsByResponseHeadersPolicyIdRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDistributionsByResponseHeadersPolicyId(request))
  def updateCachePolicy(request: UpdateCachePolicyRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.UpdateCachePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateCachePolicy(request))
  def createFunction(request: CreateFunctionRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.CreateFunctionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFunction(request))
  def updateContinuousDeploymentPolicy(
      request: UpdateContinuousDeploymentPolicyRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.UpdateContinuousDeploymentPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateContinuousDeploymentPolicy(request))
  def getOriginAccessControlConfig(
      request: GetOriginAccessControlConfigRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetOriginAccessControlConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getOriginAccessControlConfig(request))
  def getCachePolicy(request: GetCachePolicyRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetCachePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCachePolicy(request))
  def updateKeyValueStore(request: UpdateKeyValueStoreRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.UpdateKeyValueStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateKeyValueStore(request))
  def getDistribution(request: GetDistributionRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetDistributionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDistribution(request))
  def getOriginRequestPolicyConfig(
      request: GetOriginRequestPolicyConfigRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetOriginRequestPolicyConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getOriginRequestPolicyConfig(request))
  def listCloudFrontOriginAccessIdentities(
      request: ListCloudFrontOriginAccessIdentitiesRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCloudFrontOriginAccessIdentities(request))
  def updateDistribution(request: UpdateDistributionRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.UpdateDistributionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDistribution(request))
  def getFunction(request: GetFunctionRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.GetFunctionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFunction(request))
  def deleteDistribution(
      request: DeleteDistributionRequest
  ): ZIO[zio.aws.cloudfront.CloudFront, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDistribution(request))
  def updateFieldLevelEncryptionConfig(
      request: UpdateFieldLevelEncryptionConfigRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFieldLevelEncryptionConfig(request))
  def listDistributionsByKeyGroup(
      request: ListDistributionsByKeyGroupRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.ListDistributionsByKeyGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDistributionsByKeyGroup(request))
  def updateDistributionWithStagingConfig(
      request: UpdateDistributionWithStagingConfigRequest
  ): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.UpdateDistributionWithStagingConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDistributionWithStagingConfig(request))
  def createDistribution(request: CreateDistributionRequest): ZIO[
    zio.aws.cloudfront.CloudFront,
    AwsError,
    zio.aws.cloudfront.model.CreateDistributionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDistribution(request))
}
