package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateFieldLevelEncryptionConfigRequest(
    fieldLevelEncryptionConfig: zio.aws.cloudfront.model.FieldLevelEncryptionConfig,
    id: String,
    ifMatch: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigRequest = {
    import UpdateFieldLevelEncryptionConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigRequest
      .builder()
      .fieldLevelEncryptionConfig(fieldLevelEncryptionConfig.buildAwsValue())
      .id(id: java.lang.String)
      .optionallyWith(ifMatch.map(value => value: java.lang.String))(_.ifMatch)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.UpdateFieldLevelEncryptionConfigRequest.ReadOnly =
    zio.aws.cloudfront.model.UpdateFieldLevelEncryptionConfigRequest
      .wrap(buildAwsValue())
}
object UpdateFieldLevelEncryptionConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.UpdateFieldLevelEncryptionConfigRequest =
      zio.aws.cloudfront.model.UpdateFieldLevelEncryptionConfigRequest(
        fieldLevelEncryptionConfig.asEditable,
        id,
        ifMatch.map(value => value)
      )
    def fieldLevelEncryptionConfig
        : zio.aws.cloudfront.model.FieldLevelEncryptionConfig.ReadOnly
    def id: String
    def ifMatch: Optional[String]
    def getFieldLevelEncryptionConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.FieldLevelEncryptionConfig.ReadOnly
    ] = ZIO.succeed(fieldLevelEncryptionConfig)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getIfMatch: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigRequest
  ) extends zio.aws.cloudfront.model.UpdateFieldLevelEncryptionConfigRequest.ReadOnly {
    override val fieldLevelEncryptionConfig
        : zio.aws.cloudfront.model.FieldLevelEncryptionConfig.ReadOnly =
      zio.aws.cloudfront.model.FieldLevelEncryptionConfig
        .wrap(impl.fieldLevelEncryptionConfig())
    override val id: String = impl.id(): String
    override val ifMatch: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ifMatch())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigRequest
  ): zio.aws.cloudfront.model.UpdateFieldLevelEncryptionConfigRequest.ReadOnly =
    new Wrapper(impl)
}
