package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDistributionsByVpcOriginIdRequest(
    marker: Optional[String] = Optional.Absent,
    maxItems: Optional[String] = Optional.Absent,
    vpcOriginId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListDistributionsByVpcOriginIdRequest = {
    import ListDistributionsByVpcOriginIdRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByVpcOriginIdRequest
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxItems.map(value => value: java.lang.String))(
        _.maxItems
      )
      .vpcOriginId(vpcOriginId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListDistributionsByVpcOriginIdRequest.ReadOnly =
    zio.aws.cloudfront.model.ListDistributionsByVpcOriginIdRequest
      .wrap(buildAwsValue())
}
object ListDistributionsByVpcOriginIdRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByVpcOriginIdRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListDistributionsByVpcOriginIdRequest =
      zio.aws.cloudfront.model.ListDistributionsByVpcOriginIdRequest(
        marker.map(value => value),
        maxItems.map(value => value),
        vpcOriginId
      )
    def marker: Optional[String]
    def maxItems: Optional[String]
    def vpcOriginId: String
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getVpcOriginId: ZIO[Any, Nothing, String] = ZIO.succeed(vpcOriginId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByVpcOriginIdRequest
  ) extends zio.aws.cloudfront.model.ListDistributionsByVpcOriginIdRequest.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxItems: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => value: String)
    override val vpcOriginId: String = impl.vpcOriginId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByVpcOriginIdRequest
  ): zio.aws.cloudfront.model.ListDistributionsByVpcOriginIdRequest.ReadOnly =
    new Wrapper(impl)
}
