package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.Timestamp
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class InvalidationSummary(
    id: String,
    createTime: Timestamp,
    status: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.InvalidationSummary = {
    import InvalidationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.InvalidationSummary
      .builder()
      .id(id: java.lang.String)
      .createTime(Timestamp.unwrap(createTime): Instant)
      .status(status: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.InvalidationSummary.ReadOnly =
    zio.aws.cloudfront.model.InvalidationSummary.wrap(buildAwsValue())
}
object InvalidationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.InvalidationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.InvalidationSummary =
      zio.aws.cloudfront.model.InvalidationSummary(id, createTime, status)
    def id: String
    def createTime: Timestamp
    def status: String
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
    def getStatus: ZIO[Any, Nothing, String] = ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.InvalidationSummary
  ) extends zio.aws.cloudfront.model.InvalidationSummary.ReadOnly {
    override val id: String = impl.id(): String
    override val createTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.createTime())
    override val status: String = impl.status(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.InvalidationSummary
  ): zio.aws.cloudfront.model.InvalidationSummary.ReadOnly = new Wrapper(impl)
}
