package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeKeyValueStoreResponse(
    keyValueStore: Optional[zio.aws.cloudfront.model.KeyValueStore] =
      Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DescribeKeyValueStoreResponse = {
    import DescribeKeyValueStoreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DescribeKeyValueStoreResponse
      .builder()
      .optionallyWith(keyValueStore.map(value => value.buildAwsValue()))(
        _.keyValueStore
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.DescribeKeyValueStoreResponse.ReadOnly =
    zio.aws.cloudfront.model.DescribeKeyValueStoreResponse.wrap(buildAwsValue())
}
object DescribeKeyValueStoreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DescribeKeyValueStoreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DescribeKeyValueStoreResponse =
      zio.aws.cloudfront.model.DescribeKeyValueStoreResponse(
        keyValueStore.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def keyValueStore: Optional[zio.aws.cloudfront.model.KeyValueStore.ReadOnly]
    def eTag: Optional[String]
    def getKeyValueStore
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.KeyValueStore.ReadOnly] =
      AwsError.unwrapOptionField("keyValueStore", keyValueStore)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DescribeKeyValueStoreResponse
  ) extends zio.aws.cloudfront.model.DescribeKeyValueStoreResponse.ReadOnly {
    override val keyValueStore
        : Optional[zio.aws.cloudfront.model.KeyValueStore.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyValueStore())
        .map(value => zio.aws.cloudfront.model.KeyValueStore.wrap(value))
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DescribeKeyValueStoreResponse
  ): zio.aws.cloudfront.model.DescribeKeyValueStoreResponse.ReadOnly =
    new Wrapper(impl)
}
