package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateCloudFrontOriginAccessIdentityRequest(
    cloudFrontOriginAccessIdentityConfig: zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest = {
    import CreateCloudFrontOriginAccessIdentityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest
      .builder()
      .cloudFrontOriginAccessIdentityConfig(
        cloudFrontOriginAccessIdentityConfig.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest.ReadOnly =
    zio.aws.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest
      .wrap(buildAwsValue())
}
object CreateCloudFrontOriginAccessIdentityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest =
      zio.aws.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest(
        cloudFrontOriginAccessIdentityConfig.asEditable
      )
    def cloudFrontOriginAccessIdentityConfig
        : zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig.ReadOnly
    def getCloudFrontOriginAccessIdentityConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig.ReadOnly
    ] = ZIO.succeed(cloudFrontOriginAccessIdentityConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest
  ) extends zio.aws.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest.ReadOnly {
    override val cloudFrontOriginAccessIdentityConfig
        : zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig.ReadOnly =
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig
        .wrap(impl.cloudFrontOriginAccessIdentityConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest
  ): zio.aws.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest.ReadOnly =
    new Wrapper(impl)
}
