package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Tags(
    items: Optional[Iterable[zio.aws.cloudfront.model.Tag]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.cloudfront.model.Tags = {
    import Tags.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.Tags
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.Tags.ReadOnly =
    zio.aws.cloudfront.model.Tags.wrap(buildAwsValue())
}
object Tags {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.cloudfront.model.Tags] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.Tags =
      zio.aws.cloudfront.model.Tags(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def items: Optional[List[zio.aws.cloudfront.model.Tag.ReadOnly]]
    def getItems
        : ZIO[Any, AwsError, List[zio.aws.cloudfront.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.Tags
  ) extends zio.aws.cloudfront.model.Tags.ReadOnly {
    override val items: Optional[List[zio.aws.cloudfront.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudfront.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.Tags
  ): zio.aws.cloudfront.model.Tags.ReadOnly = new Wrapper(impl)
}
