package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDistributionsByAnycastIpListIdRequest(
    marker: Optional[String] = Optional.Absent,
    maxItems: Optional[String] = Optional.Absent,
    anycastIpListId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListDistributionsByAnycastIpListIdRequest = {
    import ListDistributionsByAnycastIpListIdRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByAnycastIpListIdRequest
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxItems.map(value => value: java.lang.String))(
        _.maxItems
      )
      .anycastIpListId(anycastIpListId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListDistributionsByAnycastIpListIdRequest.ReadOnly =
    zio.aws.cloudfront.model.ListDistributionsByAnycastIpListIdRequest
      .wrap(buildAwsValue())
}
object ListDistributionsByAnycastIpListIdRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByAnycastIpListIdRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListDistributionsByAnycastIpListIdRequest =
      zio.aws.cloudfront.model.ListDistributionsByAnycastIpListIdRequest(
        marker.map(value => value),
        maxItems.map(value => value),
        anycastIpListId
      )
    def marker: Optional[String]
    def maxItems: Optional[String]
    def anycastIpListId: String
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getAnycastIpListId: ZIO[Any, Nothing, String] =
      ZIO.succeed(anycastIpListId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByAnycastIpListIdRequest
  ) extends zio.aws.cloudfront.model.ListDistributionsByAnycastIpListIdRequest.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxItems: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => value: String)
    override val anycastIpListId: String = impl.anycastIpListId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByAnycastIpListIdRequest
  ): zio.aws.cloudfront.model.ListDistributionsByAnycastIpListIdRequest.ReadOnly =
    new Wrapper(impl)
}
