package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContinuousDeploymentPolicyConfig(
    stagingDistributionDnsNames: zio.aws.cloudfront.model.StagingDistributionDnsNames,
    enabled: Boolean,
    trafficConfig: Optional[zio.aws.cloudfront.model.TrafficConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyConfig = {
    import ContinuousDeploymentPolicyConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyConfig
      .builder()
      .stagingDistributionDnsNames(stagingDistributionDnsNames.buildAwsValue())
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(trafficConfig.map(value => value.buildAwsValue()))(
        _.trafficConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ContinuousDeploymentPolicyConfig.ReadOnly =
    zio.aws.cloudfront.model.ContinuousDeploymentPolicyConfig
      .wrap(buildAwsValue())
}
object ContinuousDeploymentPolicyConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ContinuousDeploymentPolicyConfig =
      zio.aws.cloudfront.model.ContinuousDeploymentPolicyConfig(
        stagingDistributionDnsNames.asEditable,
        enabled,
        trafficConfig.map(value => value.asEditable)
      )
    def stagingDistributionDnsNames
        : zio.aws.cloudfront.model.StagingDistributionDnsNames.ReadOnly
    def enabled: Boolean
    def trafficConfig: Optional[zio.aws.cloudfront.model.TrafficConfig.ReadOnly]
    def getStagingDistributionDnsNames: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.StagingDistributionDnsNames.ReadOnly
    ] = ZIO.succeed(stagingDistributionDnsNames)
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getTrafficConfig
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.TrafficConfig.ReadOnly] =
      AwsError.unwrapOptionField("trafficConfig", trafficConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyConfig
  ) extends zio.aws.cloudfront.model.ContinuousDeploymentPolicyConfig.ReadOnly {
    override val stagingDistributionDnsNames
        : zio.aws.cloudfront.model.StagingDistributionDnsNames.ReadOnly =
      zio.aws.cloudfront.model.StagingDistributionDnsNames
        .wrap(impl.stagingDistributionDnsNames())
    override val enabled: Boolean = impl.enabled(): Boolean
    override val trafficConfig
        : Optional[zio.aws.cloudfront.model.TrafficConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trafficConfig())
        .map(value => zio.aws.cloudfront.model.TrafficConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyConfig
  ): zio.aws.cloudfront.model.ContinuousDeploymentPolicyConfig.ReadOnly =
    new Wrapper(impl)
}
