package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.KeyValueStoreName
import scala.jdk.CollectionConverters._
final case class DeleteKeyValueStoreRequest(
    name: KeyValueStoreName,
    ifMatch: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DeleteKeyValueStoreRequest = {
    import DeleteKeyValueStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DeleteKeyValueStoreRequest
      .builder()
      .name(KeyValueStoreName.unwrap(name): java.lang.String)
      .ifMatch(ifMatch: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.DeleteKeyValueStoreRequest.ReadOnly =
    zio.aws.cloudfront.model.DeleteKeyValueStoreRequest.wrap(buildAwsValue())
}
object DeleteKeyValueStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DeleteKeyValueStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DeleteKeyValueStoreRequest =
      zio.aws.cloudfront.model.DeleteKeyValueStoreRequest(name, ifMatch)
    def name: KeyValueStoreName
    def ifMatch: String
    def getName: ZIO[Any, Nothing, KeyValueStoreName] = ZIO.succeed(name)
    def getIfMatch: ZIO[Any, Nothing, String] = ZIO.succeed(ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteKeyValueStoreRequest
  ) extends zio.aws.cloudfront.model.DeleteKeyValueStoreRequest.ReadOnly {
    override val name: KeyValueStoreName =
      zio.aws.cloudfront.model.primitives.KeyValueStoreName(impl.name())
    override val ifMatch: String = impl.ifMatch(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteKeyValueStoreRequest
  ): zio.aws.cloudfront.model.DeleteKeyValueStoreRequest.ReadOnly = new Wrapper(
    impl
  )
}
