package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class ResponseHeadersPolicyAccessControlAllowMethods(
    quantity: Integer,
    items: Iterable[
      zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethodsValues
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethods = {
    import ResponseHeadersPolicyAccessControlAllowMethods.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethods
      .builder()
      .quantity(quantity: java.lang.Integer)
      .itemsWithStrings(items.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethods.ReadOnly =
    zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethods
      .wrap(buildAwsValue())
}
object ResponseHeadersPolicyAccessControlAllowMethods {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethods
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethods =
      zio.aws.cloudfront.model
        .ResponseHeadersPolicyAccessControlAllowMethods(quantity, items)
    def quantity: Integer
    def items: List[
      zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethodsValues
    ]
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethodsValues
    ]] = ZIO.succeed(items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethods
  ) extends zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethods.ReadOnly {
    override val quantity: Integer = impl.quantity(): Integer
    override val items: List[
      zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethodsValues
    ] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethodsValues
          .wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethods
  ): zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethods.ReadOnly =
    new Wrapper(impl)
}
