package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateContinuousDeploymentPolicyRequest(
    continuousDeploymentPolicyConfig: zio.aws.cloudfront.model.ContinuousDeploymentPolicyConfig,
    id: String,
    ifMatch: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateContinuousDeploymentPolicyRequest = {
    import UpdateContinuousDeploymentPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateContinuousDeploymentPolicyRequest
      .builder()
      .continuousDeploymentPolicyConfig(
        continuousDeploymentPolicyConfig.buildAwsValue()
      )
      .id(id: java.lang.String)
      .optionallyWith(ifMatch.map(value => value: java.lang.String))(_.ifMatch)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.UpdateContinuousDeploymentPolicyRequest.ReadOnly =
    zio.aws.cloudfront.model.UpdateContinuousDeploymentPolicyRequest
      .wrap(buildAwsValue())
}
object UpdateContinuousDeploymentPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateContinuousDeploymentPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.UpdateContinuousDeploymentPolicyRequest =
      zio.aws.cloudfront.model.UpdateContinuousDeploymentPolicyRequest(
        continuousDeploymentPolicyConfig.asEditable,
        id,
        ifMatch.map(value => value)
      )
    def continuousDeploymentPolicyConfig
        : zio.aws.cloudfront.model.ContinuousDeploymentPolicyConfig.ReadOnly
    def id: String
    def ifMatch: Optional[String]
    def getContinuousDeploymentPolicyConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.ContinuousDeploymentPolicyConfig.ReadOnly
    ] = ZIO.succeed(continuousDeploymentPolicyConfig)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getIfMatch: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateContinuousDeploymentPolicyRequest
  ) extends zio.aws.cloudfront.model.UpdateContinuousDeploymentPolicyRequest.ReadOnly {
    override val continuousDeploymentPolicyConfig
        : zio.aws.cloudfront.model.ContinuousDeploymentPolicyConfig.ReadOnly =
      zio.aws.cloudfront.model.ContinuousDeploymentPolicyConfig
        .wrap(impl.continuousDeploymentPolicyConfig())
    override val id: String = impl.id(): String
    override val ifMatch: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ifMatch())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateContinuousDeploymentPolicyRequest
  ): zio.aws.cloudfront.model.UpdateContinuousDeploymentPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
