package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait SSLSupportMethod {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.SSLSupportMethod
}
object SSLSupportMethod {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.SSLSupportMethod
  ): zio.aws.cloudfront.model.SSLSupportMethod = value match {
    case software.amazon.awssdk.services.cloudfront.model.SSLSupportMethod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.SSLSupportMethod.SNI_ONLY =>
      val r = `sni-only`
      r
    case software.amazon.awssdk.services.cloudfront.model.SSLSupportMethod.VIP =>
      val r = vip
      r
    case software.amazon.awssdk.services.cloudfront.model.SSLSupportMethod.STATIC_IP =>
      val r = `static-ip`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.SSLSupportMethod {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.SSLSupportMethod =
      software.amazon.awssdk.services.cloudfront.model.SSLSupportMethod.UNKNOWN_TO_SDK_VERSION
  }
  case object `sni-only` extends zio.aws.cloudfront.model.SSLSupportMethod {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.SSLSupportMethod =
      software.amazon.awssdk.services.cloudfront.model.SSLSupportMethod.SNI_ONLY
  }
  case object vip extends zio.aws.cloudfront.model.SSLSupportMethod {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.SSLSupportMethod =
      software.amazon.awssdk.services.cloudfront.model.SSLSupportMethod.VIP
  }
  case object `static-ip` extends zio.aws.cloudfront.model.SSLSupportMethod {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.SSLSupportMethod =
      software.amazon.awssdk.services.cloudfront.model.SSLSupportMethod.STATIC_IP
  }
}
