package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteVpcOriginResponse(
    vpcOrigin: Optional[zio.aws.cloudfront.model.VpcOrigin] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DeleteVpcOriginResponse = {
    import DeleteVpcOriginResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DeleteVpcOriginResponse
      .builder()
      .optionallyWith(vpcOrigin.map(value => value.buildAwsValue()))(
        _.vpcOrigin
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.DeleteVpcOriginResponse.ReadOnly =
    zio.aws.cloudfront.model.DeleteVpcOriginResponse.wrap(buildAwsValue())
}
object DeleteVpcOriginResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DeleteVpcOriginResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DeleteVpcOriginResponse =
      zio.aws.cloudfront.model.DeleteVpcOriginResponse(
        vpcOrigin.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def vpcOrigin: Optional[zio.aws.cloudfront.model.VpcOrigin.ReadOnly]
    def eTag: Optional[String]
    def getVpcOrigin
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.VpcOrigin.ReadOnly] =
      AwsError.unwrapOptionField("vpcOrigin", vpcOrigin)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteVpcOriginResponse
  ) extends zio.aws.cloudfront.model.DeleteVpcOriginResponse.ReadOnly {
    override val vpcOrigin
        : Optional[zio.aws.cloudfront.model.VpcOrigin.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcOrigin())
        .map(value => zio.aws.cloudfront.model.VpcOrigin.wrap(value))
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteVpcOriginResponse
  ): zio.aws.cloudfront.model.DeleteVpcOriginResponse.ReadOnly = new Wrapper(
    impl
  )
}
