package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AnycastIpListCollection(
    items: Optional[Iterable[zio.aws.cloudfront.model.AnycastIpListSummary]] =
      Optional.Absent,
    marker: String,
    nextMarker: Optional[String] = Optional.Absent,
    maxItems: Integer,
    isTruncated: Boolean,
    quantity: Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.AnycastIpListCollection = {
    import AnycastIpListCollection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.AnycastIpListCollection
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .marker(marker: java.lang.String)
      .optionallyWith(nextMarker.map(value => value: java.lang.String))(
        _.nextMarker
      )
      .maxItems(maxItems: java.lang.Integer)
      .isTruncated(isTruncated: java.lang.Boolean)
      .quantity(quantity: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.AnycastIpListCollection.ReadOnly =
    zio.aws.cloudfront.model.AnycastIpListCollection.wrap(buildAwsValue())
}
object AnycastIpListCollection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.AnycastIpListCollection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.AnycastIpListCollection =
      zio.aws.cloudfront.model.AnycastIpListCollection(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker,
        nextMarker.map(value => value),
        maxItems,
        isTruncated,
        quantity
      )
    def items
        : Optional[List[zio.aws.cloudfront.model.AnycastIpListSummary.ReadOnly]]
    def marker: String
    def nextMarker: Optional[String]
    def maxItems: Integer
    def isTruncated: Boolean
    def quantity: Integer
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.AnycastIpListSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getMarker: ZIO[Any, Nothing, String] = ZIO.succeed(marker)
    def getNextMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getMaxItems: ZIO[Any, Nothing, Integer] = ZIO.succeed(maxItems)
    def getIsTruncated: ZIO[Any, Nothing, Boolean] = ZIO.succeed(isTruncated)
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.AnycastIpListCollection
  ) extends zio.aws.cloudfront.model.AnycastIpListCollection.ReadOnly {
    override val items: Optional[
      List[zio.aws.cloudfront.model.AnycastIpListSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudfront.model.AnycastIpListSummary.wrap(item)
        }.toList
      )
    override val marker: String = impl.marker(): String
    override val nextMarker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => value: String)
    override val maxItems: Integer = impl.maxItems(): Integer
    override val isTruncated: Boolean = impl.isTruncated(): Boolean
    override val quantity: Integer = impl.quantity(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.AnycastIpListCollection
  ): zio.aws.cloudfront.model.AnycastIpListCollection.ReadOnly = new Wrapper(
    impl
  )
}
